#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

def Update_CropSet(infc1, Merge, Filestem):
##########################################################################################################################
#Update attribute table data
##########################################################################################################################
    try:
            
        #Output
        outfc = "ICPR4_CROP_SET"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "PM_CropCoefSet.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'COMMENT',
                  'ICPR_GUID']                  

                  
        #List index
        GDB_NAME = fields.index('NAME')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data           
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")    
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursor:
                                
                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_COMMENT] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                    
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            NAME = data[CSV_Name]
                            COMMENT = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]

                            In_Data = (NAME,
                                       COMMENT,
                                       ICPR_GUID)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name]]            
                del cursorInsert
                            
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()

##########################################################################################################################
#Populated Child Table 1
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_CROP_COEF"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "PM_CropCoefSet_CropCoef.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['CropCoefZone',
                      'AllowSaturatedET',
                      'IrrigationSource',
                      'Node',
                      'ShutOffElevation',
                      'Feature_GW_IrrigationWell',
                      'IrrigationRule',
                      'PctWiltingToField',
                      'AntecedentRainfallAmount',
                      'AntecedentDuration',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_CropCoefZone = fields.index('CropCoefZone')
            GDB_AllowSaturatedET = fields.index('AllowSaturatedET')
            GDB_IrrigationSource = fields.index('IrrigationSource')
            GDB_Node = fields.index('Node')
            GDB_ShutOffElevation = fields.index('ShutOffElevation')
            GDB_Feature_GW_IrrigationWell = fields.index('Feature_GW_IrrigationWell')
            GDB_IrrigationRule = fields.index('IrrigationRule')
            GDB_PctWiltingToField = fields.index('PctWiltingToField')
            GDB_AntecedentRainfallAmount = fields.index('AntecedentRainfallAmount')
            GDB_AntecedentDuration = fields.index('AntecedentDuration')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')

            #Create new Dictionary
            Dict = {}
            
            with open(infc,'r') as csv_file:
                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                
                for line in csv_file:
                    if first== True:
                        first = False

                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")                        
                        CSV_CropCoefZone = header_row.index("CropCoefZone")
                        CSV_AllowSaturatedET = header_row.index("AllowSaturatedET")
                        CSV_IrrigationSource = header_row.index("IrrigationSource")
                        CSV_Node = header_row.index("Node")
                        CSV_ShutOffElevation = header_row.index("ShutOffElevation")
                        CSV_Feature_GW_IrrigationWell = header_row.index("Feature_GW_IrrigationWell")
                        CSV_IrrigationRule = header_row.index("IrrigationRule")
                        CSV_PctWiltingToField = header_row.index("PctWiltingToField")
                        CSV_AntecedentRainfallAmount = header_row.index("AntecedentRainfallAmount")
                        CSV_AntecedentDuration = header_row.index("AntecedentDuration")
                        
                    else:

                        data = iccsv.csv_parseline(line)

                        data[CSV_AllowSaturatedET] = int(data[CSV_AllowSaturatedET])
                        data[CSV_ShutOffElevation] = float(data[CSV_ShutOffElevation])
                        data[CSV_IrrigationRule] = int(data[CSV_IrrigationRule])
                        data[CSV_PctWiltingToField] = float(data[CSV_PctWiltingToField])
                        data[CSV_AntecedentRainfallAmount] = float(data[CSV_AntecedentRainfallAmount])
                        data[CSV_AntecedentDuration] = float(data[CSV_AntecedentDuration])
                        
                        #Populate Name
                        try:                    
                            SET_NAME = AddDict[data[CSV_ParentID]][1]
                        except:
                            SET_NAME = UpDict[data[CSV_ParentID]][1]
                            
                        CropCoefZone = data[CSV_CropCoefZone]
                        AllowSaturatedET = data[CSV_AllowSaturatedET]
                        IrrigationSource = data[CSV_IrrigationSource]
                        Node = data[CSV_Node]
                        ShutOffElevation = data[CSV_ShutOffElevation]
                        Feature_GW_IrrigationWell = data[CSV_Feature_GW_IrrigationWell]
                        IrrigationRule = data[CSV_IrrigationRule]
                        PctWiltingToField = data[CSV_PctWiltingToField]
                        AntecedentRainfallAmount = data[CSV_AntecedentRainfallAmount]
                        AntecedentDuration = data[CSV_AntecedentDuration]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (CropCoefZone,
                                   AllowSaturatedET,
                                   IrrigationSource,
                                   Node,
                                   ShutOffElevation,
                                   Feature_GW_IrrigationWell,
                                   IrrigationRule,
                                   PctWiltingToField,
                                   AntecedentRainfallAmount,
                                   AntecedentDuration,
                                   SET_NAME,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)    
                        Dict[ICPR_GUID] = [CropCoefZone,SET_NAME]
                        
                del cursorInsert


        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    


##########################################################################################################################
#Populated Child Table 2
##########################################################################################################################
    try:                
        #Output
        outfc = "ICPR4_CROP_COEF_CYCLE"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "PM_CropCoefSet_CropCoef_Cycle.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete table data to repopulate
        try:
            arcpy.DeleteRows_management(outfc)
        except:
            pass

        #Delete if merge is false otherwise merge
        try:

            #Append new/updated data
            fields = ['CropCoefZone',
                      'Year',
                      'Month',
                      'Day',
                      'CropCoef',
                      'RootDepth',
                      'IrrigationRate',
                      'IrrigationEfficiency',
                      'SET_NAME',
                      'ICPR_GUID']

            GDB_CropCoefZone = fields.index('CropCoefZone')
            GDB_Year = fields.index('Year')
            GDB_Month = fields.index('Month')
            GDB_Day = fields.index('Day')
            GDB_CropCoef = fields.index('CropCoef')
            GDB_RootDepth = fields.index('RootDepth')
            GDB_IrrigationRate = fields.index('IrrigationRate')
            GDB_IrrigationEfficiency = fields.index('IrrigationEfficiency')
            GDB_SET_NAME = fields.index('SET_NAME')
            GDB_ICPR_GUID = fields.index('ICPR_GUID')
            
            with open(infc,'r') as csv_file:                
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                
                for line in csv_file:
                    if first== True:
                        first = False

                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Year = header_row.index("Year")
                        CSV_Month = header_row.index("Month")
                        CSV_Day = header_row.index("Day")
                        CSV_CropCoef = header_row.index("CropCoef")
                        CSV_RootDepth = header_row.index("RootDepth")
                        CSV_IrrigationRate = header_row.index("IrrigationRate")
                        CSV_IrrigationEfficiency = header_row.index("IrrigationEfficiency")                        

                    else:

                        data = iccsv.csv_parseline(line)
                        
                        #Data
                        data[CSV_Year] = int(data[CSV_Year])
                        data[CSV_Month] = int(data[CSV_Month])
                        data[CSV_Day] = int(data[CSV_Day])
                        data[CSV_CropCoef] = float(data[CSV_CropCoef])
                        data[CSV_RootDepth] = float(data[CSV_RootDepth])
                        data[CSV_IrrigationRate] = float(data[CSV_IrrigationRate])
                        data[CSV_IrrigationEfficiency] = float(data[CSV_IrrigationEfficiency])
                        
                        #Populate Name
                        try:                    
                            SET_NAME = Dict[data[CSV_ParentID]][1]
                            CropCoefZone = Dict[data[CSV_ParentID]][0]
                        except:
                            SET_NAME = Dict[data[CSV_ParentID]][1]
                            CropCoefZone = Dict[data[CSV_ParentID]][0]
                                
                        Year = data[CSV_Year]
                        Month = data[CSV_Month]
                        Day = data[CSV_Day]
                        CropCoef = data[CSV_CropCoef]
                        RootDepth = data[CSV_RootDepth]
                        IrrigationRate = data[CSV_IrrigationRate]
                        IrrigationEfficiency = data[CSV_IrrigationEfficiency]
                        ICPR_GUID = data[CSV_ID]

                        In_Data = (CropCoefZone,
                                   Year,
                                   Month,
                                   Day,
                                   CropCoef,
                                   RootDepth,
                                   IrrigationRate,
                                   IrrigationEfficiency,
                                   SET_NAME,
                                   ICPR_GUID)   

                        #Insert new record                        
                        cursorInsert.insertRow(In_Data)       
                del cursorInsert


        except:
            arcpy.GetMessages()

    except:
        arcpy.GetMessages()    
