#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Overland Flow Region module
##########################################################################################################################
def UpdateOFRegion(infc1, Merge, Filestem, ScenDict):


##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "OF_Region"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "OverlandFlowRegion.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['Scenario',
                  'Comment',
                  'Name',
                  'ICPR_GUID',
                  'MinTriangulationAngle',
                  'MinTriangulationArea',
                  'CellSize_DiamondLayer',
                  'CellSize_HoneycombLayer',
                  'Surface_Ground',
                  'Ground_UseSingleElevation',
                  'GroundElevation',
                  'Surface_InitialStage',
                  'InitialStage_UseSingleElevation',
                  'InitialStageElevation',
                  'MapLayer_RoughnessZone',
                  'UseSingleRoughnessZone',
                  'RoughnessZone',
                  'MapLayer_SoilZone',
                  'UseSingleSoilZone',
                  'SoilZone',
                  'MapLayer_LandCoverZone',
                  'UseSingleLandCoverZone',
                  'LandCoverZone',
                  'MapLayer_RainfallZone',
                  'UseSingleRainfallZone',
                  'RainfallZone',
                  'UseRegionAsMappedBasinFeature',
                  'MapLayer_MappedBasin',
                  'UseSingleMappedBasin',
                  'MappedBasin',
                  'MapLayer_InfiltrationMethod',
                  'UseSingleInfiltrationMethod',
                  'InfiltrationMethod',
                  'IncludeEvapotranspiration',
                  'MapLayer_ReferenceET',
                  'UseSingleReferenceETStation',
                  'ReferenceETStation',
                  'MapLayer_CropCoefZone',
                  'UseSingleCropCoefZone',
                  'CropCoefZone',
                  'MaxTriangulationArea',
                  'BoundaryPointSpacing']  
                  
        #List index
        GDB_Scenario = fields.index('Scenario')
        GDB_Comment = fields.index('Comment')
        GDB_Name = fields.index('Name')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_MinTriangulationAngle = fields.index('MinTriangulationAngle')
        GDB_MinTriangulationArea = fields.index('MinTriangulationArea')
        GDB_CellSize_DiamondLayer = fields.index('CellSize_DiamondLayer')
        GDB_CellSize_HoneycombLayer = fields.index('CellSize_HoneycombLayer')
        GDB_Surface_Ground = fields.index('Surface_Ground')
        GDB_Ground_UseSingleElevation = fields.index('Ground_UseSingleElevation')
        GDB_GroundElevation = fields.index('GroundElevation')
        GDB_Surface_InitialStage = fields.index('Surface_InitialStage')
        GDB_InitialStage_UseSingleElevation = fields.index('InitialStage_UseSingleElevation')
        GDB_InitialStageElevation = fields.index('InitialStageElevation')
        GDB_MapLayer_RoughnessZone = fields.index('MapLayer_RoughnessZone')
        GDB_UseSingleRoughnessZone = fields.index('UseSingleRoughnessZone')
        GDB_RoughnessZone = fields.index('RoughnessZone')
        GDB_MapLayer_SoilZone = fields.index('MapLayer_SoilZone')
        GDB_UseSingleSoilZone = fields.index('UseSingleSoilZone')
        GDB_SoilZone = fields.index('SoilZone')
        GDB_MapLayer_LandCoverZone = fields.index('MapLayer_LandCoverZone')
        GDB_UseSingleLandCoverZone = fields.index('UseSingleLandCoverZone')
        GDB_LandCoverZone = fields.index('LandCoverZone')
        GDB_MapLayer_RainfallZone = fields.index('MapLayer_RainfallZone')
        GDB_UseSingleRainfallZone = fields.index('UseSingleRainfallZone')
        GDB_RainfallZone = fields.index('RainfallZone')
        GDB_UseRegionAsMappedBasinFeature = fields.index('UseRegionAsMappedBasinFeature')
        GDB_MapLayer_MappedBasin = fields.index('MapLayer_MappedBasin')
        GDB_UseSingleMappedBasin = fields.index('UseSingleMappedBasin')
        GDB_MappedBasin = fields.index('MappedBasin')
        GDB_MapLayer_InfiltrationMethod = fields.index('MapLayer_InfiltrationMethod')
        GDB_UseSingleInfiltrationMethod = fields.index('UseSingleInfiltrationMethod')
        GDB_InfiltrationMethod = fields.index('InfiltrationMethod')
        GDB_IncludeEvapotranspiration = fields.index('IncludeEvapotranspiration')
        GDB_MapLayer_ReferenceET = fields.index('MapLayer_ReferenceET')
        GDB_UseSingleReferenceETStation = fields.index('UseSingleReferenceETStation')
        GDB_ReferenceETStation = fields.index('ReferenceETStation')
        GDB_MapLayer_CropCoefZone = fields.index('MapLayer_CropCoefZone')
        GDB_UseSingleCropCoefZone = fields.index('UseSingleCropCoefZone')
        GDB_CropCoefZone = fields.index('CropCoefZone')
        GDB_MaxTriangulationArea = fields.index('MaxTriangulationArea')
        GDB_BoundaryPointSpacing = fields.index('BoundaryPointSpacing')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data        
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Comment = header_row.index("Comment")                    
                        CSV_MinTriangulationAngle = header_row.index('MinTriangulationAngle')
                        CSV_MinTriangulationArea = header_row.index('MinTriangulationArea')
                        CSV_CellSize_DiamondLayer = header_row.index('CellSize_DiamondLayer')
                        CSV_CellSize_HoneycombLayer = header_row.index('CellSize_HoneycombLayer')
                        CSV_Surface_Ground = header_row.index('Surface_Ground')
                        CSV_Ground_UseSingleElevation = header_row.index('Ground_UseSingleElevation')
                        CSV_GroundElevation = header_row.index('GroundElevation')
                        CSV_Surface_InitialStage = header_row.index('Surface_InitialStage')
                        CSV_InitialStage_UseSingleElevation = header_row.index('InitialStage_UseSingleElevation')
                        CSV_InitialStageElevation = header_row.index('InitialStageElevation')
                        CSV_MapLayer_RoughnessZone = header_row.index('MapLayer_RoughnessZone')
                        CSV_UseSingleRoughnessZone = header_row.index('UseSingleRoughnessZone')
                        CSV_RoughnessZone = header_row.index('RoughnessZone')
                        CSV_MapLayer_SoilZone = header_row.index('MapLayer_SoilZone')
                        CSV_UseSingleSoilZone = header_row.index('UseSingleSoilZone')
                        CSV_SoilZone = header_row.index('SoilZone')
                        CSV_MapLayer_LandCoverZone = header_row.index('MapLayer_LandCoverZone')
                        CSV_UseSingleLandCoverZone = header_row.index('UseSingleLandCoverZone')
                        CSV_LandCoverZone = header_row.index('LandCoverZone')
                        CSV_MapLayer_RainfallZone = header_row.index('MapLayer_RainfallZone')
                        CSV_UseSingleRainfallZone = header_row.index('UseSingleRainfallZone')
                        CSV_RainfallZone = header_row.index('RainfallZone')
                        CSV_UseRegionAsMappedBasinFeature = header_row.index('UseRegionAsMappedBasinFeature')
                        CSV_MapLayer_MappedBasin = header_row.index('MapLayer_MappedBasin')
                        CSV_UseSingleMappedBasin = header_row.index('UseSingleMappedBasin')
                        CSV_MappedBasin = header_row.index('MappedBasin')
                        CSV_MapLayer_InfiltrationMethod = header_row.index('MapLayer_InfiltrationMethod')
                        CSV_UseSingleInfiltrationMethod = header_row.index('UseSingleInfiltrationMethod')
                        CSV_InfiltrationMethod = header_row.index('InfiltrationMethod')
                        CSV_IncludeEvapotranspiration = header_row.index('IncludeEvapotranspiration')
                        CSV_MapLayer_ReferenceET = header_row.index('MapLayer_ReferenceET')
                        CSV_UseSingleReferenceETStation = header_row.index('UseSingleReferenceETStation')
                        CSV_ReferenceETStation = header_row.index('ReferenceETStation')
                        CSV_MapLayer_CropCoefZone = header_row.index('MapLayer_CropCoefZone')
                        CSV_UseSingleCropCoefZone = header_row.index('UseSingleCropCoefZone')
                        CSV_CropCoefZone = header_row.index('CropCoefZone')
                        CSV_MaxTriangulationArea = header_row.index('MaxTriangulationArea')
                        CSV_BoundaryPointSpacing = header_row.index('BoundaryPointSpacing')
                        
                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                                
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:
                                
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_Comment] = data[CSV_Comment]
                                row[GDB_Name] = data[CSV_Name]
                                row[GDB_Scenario] = ScenDict[data[CSV_ParentID]][1]
                                row[GDB_MinTriangulationAngle] = data[CSV_MinTriangulationAngle]
                                row[GDB_MinTriangulationArea] = data[CSV_MinTriangulationArea]
                                row[GDB_CellSize_DiamondLayer] = data[CSV_CellSize_DiamondLayer]
                                row[GDB_CellSize_HoneycombLayer] = data[CSV_CellSize_HoneycombLayer]
                                row[GDB_Surface_Ground] = data[CSV_Surface_Ground]
                                row[GDB_Ground_UseSingleElevation] = data[CSV_Ground_UseSingleElevation]
                                row[GDB_GroundElevation] = data[CSV_GroundElevation]
                                row[GDB_Surface_InitialStage] = data[CSV_Surface_InitialStage]
                                row[GDB_InitialStage_UseSingleElevation] = data[CSV_InitialStage_UseSingleElevation]
                                row[GDB_InitialStageElevation] = data[CSV_InitialStageElevation]
                                row[GDB_MapLayer_RoughnessZone] = data[CSV_MapLayer_RoughnessZone]
                                row[GDB_UseSingleRoughnessZone] = data[CSV_UseSingleRoughnessZone]
                                row[GDB_RoughnessZone] = data[CSV_RoughnessZone]
                                row[GDB_MapLayer_SoilZone] = data[CSV_MapLayer_SoilZone]
                                row[GDB_UseSingleSoilZone] = data[CSV_UseSingleSoilZone]
                                row[GDB_SoilZone] = data[CSV_SoilZone]
                                row[GDB_MapLayer_LandCoverZone] = data[CSV_MapLayer_LandCoverZone]
                                row[GDB_UseSingleLandCoverZone] = data[CSV_UseSingleLandCoverZone]
                                row[GDB_LandCoverZone] = data[CSV_LandCoverZone]
                                row[GDB_MapLayer_RainfallZone] = data[CSV_MapLayer_RainfallZone]
                                row[GDB_UseSingleRainfallZone] = data[CSV_UseSingleRainfallZone]
                                row[GDB_RainfallZone] = data[CSV_RainfallZone]
                                row[GDB_UseRegionAsMappedBasinFeature] = data[CSV_UseRegionAsMappedBasinFeature]
                                row[GDB_MapLayer_MappedBasin] = data[CSV_MapLayer_MappedBasin]
                                row[GDB_UseSingleMappedBasin] = data[CSV_UseSingleMappedBasin]
                                row[GDB_MappedBasin] = data[CSV_MappedBasin]
                                row[GDB_MapLayer_InfiltrationMethod] = data[CSV_MapLayer_InfiltrationMethod]
                                row[GDB_UseSingleInfiltrationMethod] = data[CSV_UseSingleInfiltrationMethod]
                                row[GDB_InfiltrationMethod] = data[CSV_InfiltrationMethod]
                                row[GDB_IncludeEvapotranspiration] = data[CSV_IncludeEvapotranspiration]
                                row[GDB_MapLayer_ReferenceET] = data[CSV_MapLayer_ReferenceET]
                                row[GDB_UseSingleReferenceETStation] = data[CSV_UseSingleReferenceETStation]
                                row[GDB_ReferenceETStation] = data[CSV_ReferenceETStation]
                                row[GDB_MapLayer_CropCoefZone] = data[CSV_MapLayer_CropCoefZone]
                                row[GDB_UseSingleCropCoefZone] = data[CSV_UseSingleCropCoefZone]
                                row[GDB_CropCoefZone] = data[CSV_CropCoefZone]
                                row[GDB_MaxTriangulationArea] = data[CSV_MaxTriangulationArea]
                                row[GDB_BoundaryPointSpacing] = data[CSV_BoundaryPointSpacing]
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]] = [data[CSV_ID], data[CSV_Name]]
                                
                            del cursorUpdate                           
                                

                        #Add new data
                        else:
                            
                            ICPR_GUID = data[CSV_ID]
                            Comment = data[CSV_Comment]
                            Name = data[CSV_Name]
                            Scenario = ScenDict[data[CSV_ParentID]][1]
                            MinTriangulationAngle = data[CSV_MinTriangulationAngle]
                            MinTriangulationArea = data[CSV_MinTriangulationArea]
                            CellSize_DiamondLayer = data[CSV_CellSize_DiamondLayer]
                            CellSize_HoneycombLayer = data[CSV_CellSize_HoneycombLayer]
                            Surface_Ground = data[CSV_Surface_Ground]
                            Ground_UseSingleElevation = data[CSV_Ground_UseSingleElevation]
                            GroundElevation = data[CSV_GroundElevation]
                            Surface_InitialStage = data[CSV_Surface_InitialStage]
                            InitialStage_UseSingleElevation = data[CSV_InitialStage_UseSingleElevation]
                            InitialStageElevation = data[CSV_InitialStageElevation]
                            MapLayer_RoughnessZone = data[CSV_MapLayer_RoughnessZone]
                            UseSingleRoughnessZone = data[CSV_UseSingleRoughnessZone]
                            RoughnessZone = data[CSV_RoughnessZone]
                            MapLayer_SoilZone = data[CSV_MapLayer_SoilZone]
                            UseSingleSoilZone = data[CSV_UseSingleSoilZone]
                            SoilZone = data[CSV_SoilZone]
                            MapLayer_LandCoverZone = data[CSV_MapLayer_LandCoverZone]
                            UseSingleLandCoverZone = data[CSV_UseSingleLandCoverZone]
                            LandCoverZone = data[CSV_LandCoverZone]
                            MapLayer_RainfallZone = data[CSV_MapLayer_RainfallZone]
                            UseSingleRainfallZone = data[CSV_UseSingleRainfallZone]
                            RainfallZone = data[CSV_RainfallZone]
                            UseRegionAsMappedBasinFeature = data[CSV_UseRegionAsMappedBasinFeature]
                            MapLayer_MappedBasin = data[CSV_MapLayer_MappedBasin]
                            UseSingleMappedBasin = data[CSV_UseSingleMappedBasin]
                            MappedBasin = data[CSV_MappedBasin]
                            MapLayer_InfiltrationMethod = data[CSV_MapLayer_InfiltrationMethod]
                            UseSingleInfiltrationMethod = data[CSV_UseSingleInfiltrationMethod]
                            InfiltrationMethod = data[CSV_InfiltrationMethod]
                            IncludeEvapotranspiration = data[CSV_IncludeEvapotranspiration]
                            MapLayer_ReferenceET = data[CSV_MapLayer_ReferenceET]
                            UseSingleReferenceETStation = data[CSV_UseSingleReferenceETStation]
                            ReferenceETStation = data[CSV_ReferenceETStation]
                            MapLayer_CropCoefZone = data[CSV_MapLayer_CropCoefZone]
                            UseSingleCropCoefZone = data[CSV_UseSingleCropCoefZone]
                            CropCoefZone = data[CSV_CropCoefZone]
                            MaxTriangulationArea = data[CSV_MaxTriangulationArea]
                            BoundaryPointSpacing = data[CSV_BoundaryPointSpacing]

                            In_Data = (Scenario,
                                       Comment,
                                       Name,
                                       ICPR_GUID,
                                       MinTriangulationAngle,
                                       MinTriangulationArea,
                                       CellSize_DiamondLayer,
                                       CellSize_HoneycombLayer,
                                       Surface_Ground,
                                       Ground_UseSingleElevation,
                                       GroundElevation,
                                       Surface_InitialStage,
                                       InitialStage_UseSingleElevation,
                                       InitialStageElevation,
                                       MapLayer_RoughnessZone,
                                       UseSingleRoughnessZone,
                                       RoughnessZone,
                                       MapLayer_SoilZone,
                                       UseSingleSoilZone,
                                       SoilZone,
                                       MapLayer_LandCoverZone,
                                       UseSingleLandCoverZone,
                                       LandCoverZone,
                                       MapLayer_RainfallZone,
                                       UseSingleRainfallZone,
                                       RainfallZone,
                                       UseRegionAsMappedBasinFeature,
                                       MapLayer_MappedBasin,
                                       UseSingleMappedBasin,
                                       MappedBasin,
                                       MapLayer_InfiltrationMethod,
                                       UseSingleInfiltrationMethod,
                                       InfiltrationMethod,
                                       IncludeEvapotranspiration,
                                       MapLayer_ReferenceET,
                                       UseSingleReferenceETStation,
                                       ReferenceETStation,
                                       MapLayer_CropCoefZone,
                                       UseSingleCropCoefZone,
                                       CropCoefZone,
                                       MaxTriangulationArea,
                                       BoundaryPointSpacing)   

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]= [data[CSV_ID], data[CSV_Name]]          
                del cursorInsert
                
    except:

        arcpy.GetMessages()
            
    #Cycle through all data to delete values if required
    try:        
        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        
        arcpy.GetMessages()        
        


##########################################################################################################################
#Populated Geometry
##########################################################################################################################
    try:            
        #Output
        outfc = "OF_Region"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "OverlandFlowRegion_Point.csv" 

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Delete if merge is false otherwise merge
        try:            

           #Flags for feature geometry data
            Pnts_done = False
            Pnts = []
            Guid_Old = None
            GeomDict = {}#geometry dicationary            
            
            with open(infc,'r') as csv_file:
                first = True
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Vertex = header_row.index("Vertex")
                        CSV_X = header_row.index("X")
                        CSV_Y = header_row.index("Y")
                        
                    else:

                        data = iccsv.csv_parseline(line)
                        Guid_New = data[CSV_ParentID]
                        
                        #Initialize old GUID.  Only happens during the first pass.
                        if Guid_Old == None:
                            Guid_Old = data[CSV_ParentID]
                        
                        #Check if point array is done
                        if Guid_Old != Guid_New:                                                     
                            
                            GeomDict[Guid_Old] = Pnts #update dictionary values each time it reads a new record.                                                                        
                            Guid_Old = Guid_New #Reset old GUID
                            Pnts = [] #Empty array
                            
                            
                        
                        #Create point
                        pnt = (data[CSV_X],data[CSV_Y])
                        Pnts.append(pnt)                                
        
            #Add last record to dictionary
            GeomDict[Guid_New] = Pnts #update dictionary values each time it reads a new record.             
            
        except:
        
            arcpy.GetMessages()
        
         #Write geometry data to feature class           
        fields = ['ICPR_GUID',
                  'Shape@']

        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_SHAPE = fields.index('Shape@')
        
        cursorUpdate = arcpy.da.UpdateCursor(outfc,fields)       
        for row in cursorUpdate:
            try:
                Guid = row[GDB_ICPR_GUID]
                Geom = GeomDict[Guid]
                
                #add geometry
                row[GDB_SHAPE] = Geom
                cursorUpdate.updateRow(row)
                
            except:
                continue

        del cursorUpdate

    except:
        arcpy.GetMessages()
        
        
    #Return values
    try:

        return AddDict, UpDict

    except:
        arcpy.GetMessages()
