#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Node module
##########################################################################################################################
def UpdateNode(infc1, Merge, Filestem, NodeTypeDict,ScenDict):


##########################################################################################################################
#Update attribute table data and geometry for Node Points
##########################################################################################################################

    try:

        #Output
        outfc = "ICPR_NODE"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Node.csv"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass


        #Fields for update of existing elements/features
        fields = ['NAME',
                  'TYPE',
                  'BASE_FLOW',
                  'INITIAL_STAGE',
                  'WARNING_STAGE',
                  'AlertStage',
                  'ISPLACED',
                  'SCENARIO',
                  'BOUNDARY_STAGE',
                  'COMMENT',
                  'ICPR_GUID',
                  'Shape@',
                  'WQ_WQOption',
                  'WQ_Comment',
                  'WQ_ShapeX',
                  'WQ_ShapeY',
                  'WQ_ShapeZ',
                  'WQ_IsPlaced']

        fields2 = ['NAME',
                  'TYPE',
                  'BASE_FLOW',
                  'INITIAL_STAGE',
                  'WARNING_STAGE',
                  'AlertStage',
                  'ISPLACED',
                  'SCENARIO',
                  'BOUNDARY_STAGE',
                  'COMMENT',
                  'ICPR_GUID',
                  'WQ_WQOption',
                  'WQ_Comment',
                  'WQ_ShapeX',
                  'WQ_ShapeY',
                  'WQ_ShapeZ',
                  'WQ_IsPlaced']

        #List index
        GDB_NAME = fields.index('NAME')
        GDB_TYPE = fields.index('TYPE')
        GDB_BASE_FLOW = fields.index('BASE_FLOW')
        GDB_INITIAL_STAGE = fields.index('INITIAL_STAGE')
        GDB_WARNING_STAGE = fields.index('WARNING_STAGE')
        GDB_AlertStage = fields.index('AlertStage')        
        GDB_ISPLACED = fields.index('ISPLACED')
        GDB_SCENARIO = fields.index('SCENARIO')
        GDB_BOUNDARY_STAGE = fields.index('BOUNDARY_STAGE')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_Shape = fields.index('Shape@')
        GDB_WQ_WQOption = fields.index('WQ_WQOption')
        GDB_WQ_Comment = fields.index('WQ_Comment')
        GDB_WQ_ShapeX = fields.index('WQ_ShapeX')
        GDB_WQ_ShapeY = fields.index('WQ_ShapeY')
        GDB_WQ_ShapeZ = fields.index('WQ_ShapeZ')
        GDB_WQ_IsPlaced = fields.index('WQ_IsPlaced')


        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Check if geometric network exists
        desc = arcpy.Describe("Model")
        path = desc.path

        #List data in dataset
        C_List = desc.Children
        del desc

        #Check for geometric network
        try:

            for C in C_List:
                in_file = path + "\\" + "Model" + "\\" + C.baseName

                desc = arcpy.Describe(in_file)
                if desc.dataType == "GeometricNetwork":
                    arcpy.Delete_management(in_file)

        except:
            arcpy.GetMessages()

        #Read CSV Data
        with arcpy.da.Editor(path)as edit:

            with open(infc,'r') as csv_file:
                first = True
                #Has XY Data
                cursorInsert1 = arcpy.da.InsertCursor(outfc, fields)
                #No XY provided, so geometry data will not be populated
                cursorInsert2 = arcpy.da.InsertCursor(outfc, fields2)
                
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Type = header_row.index("Type")
                        CSV_BaseFlow = header_row.index("BaseFlow")
                        CSV_InitialStage = header_row.index("InitialStage")
                        CSV_WarningStage = header_row.index("WarningStage")
                        CSV_AlertStage = header_row.index("AlertStage")
                        CSV_BoundaryStage = header_row.index("BoundaryStage")
                        CSV_Comment = header_row.index("Comment")
                        CSV_ShapeX = header_row.index("ShapeX")
                        CSV_ShapeY = header_row.index("ShapeY")
                        CSV_ShapeZ = header_row.index("ShapeZ")
                        CSV_TextX = header_row.index("TextX")
                        CSV_TextY = header_row.index("TextY")
                        CSV_TextZ = header_row.index("TextZ")
                        CSV_TextAngle = header_row.index("TextAngle")
                        CSV_IsPlaced = header_row.index("IsPlaced")
                        CSV_WQ_WQOption = header_row.index("WQ_WQOption")
                        CSV_WQ_Comment = header_row.index("WQ_Comment")
                        CSV_WQ_ShapeX = header_row.index("WQ_ShapeX")
                        CSV_WQ_ShapeY = header_row.index("WQ_ShapeY")
                        CSV_WQ_ShapeZ = header_row.index("WQ_ShapeZ")
                        CSV_WQ_IsPlaced = header_row.index("WQ_IsPlaced")

                    else:

                        data = iccsv.csv_parseline(line)

                        #Set data formats for non-text used fields
                        data[CSV_Type] = int(data[CSV_Type])
                        data[CSV_BaseFlow] = float(data[CSV_BaseFlow])
                        data[CSV_InitialStage] = float(data[CSV_InitialStage])
                        data[CSV_WarningStage] = float(data[CSV_WarningStage])
                        data[CSV_AlertStage] = float(data[CSV_AlertStage])
                        data[CSV_IsPlaced] = int(data[CSV_IsPlaced])
                        data[CSV_WQ_WQOption] = int(data[CSV_WQ_WQOption])
                        data[CSV_WQ_ShapeX] = float(data[CSV_WQ_ShapeX])
                        data[CSV_WQ_ShapeY] = float(data[CSV_WQ_ShapeY])
                        data[CSV_WQ_ShapeZ] = float(data[CSV_WQ_ShapeZ])
                        data[CSV_WQ_IsPlaced] = int(data[CSV_WQ_IsPlaced])

                        Coord = False

                        if int(data[CSV_IsPlaced]) == 1:

                            Coord = True
                            data[CSV_ShapeX] = float(data[CSV_ShapeX])
                            data[CSV_ShapeY] = float(data[CSV_ShapeY])


                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"

                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break

                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                row[GDB_NAME] = data[CSV_Name]

                                Type = NodeTypeDict[data[CSV_Type]][1]
                                row[GDB_TYPE] = Type

                                row[GDB_BASE_FLOW] = data[CSV_BaseFlow]
                                row[GDB_INITIAL_STAGE] = data[CSV_InitialStage]
                                row[GDB_WARNING_STAGE] = data[CSV_WarningStage]
                                row[GDB_AlertStage] = data[CSV_AlertStage]
                                
                                row[GDB_ISPLACED] = data[CSV_IsPlaced]

                                row[GDB_SCENARIO] = ScenDict[data[CSV_ParentID]][1]

                                row[GDB_BOUNDARY_STAGE] = data[CSV_BoundaryStage]
                                row[GDB_COMMENT] = data[CSV_Comment]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_WQ_WQOption] = data[CSV_WQ_WQOption]
                                row[GDB_WQ_Comment] = data[CSV_WQ_Comment]
                                row[GDB_WQ_ShapeX] = data[CSV_WQ_ShapeX]
                                row[GDB_WQ_ShapeY] = data[CSV_WQ_ShapeY]
                                row[GDB_WQ_ShapeZ] = data[CSV_WQ_ShapeZ]
                                row[GDB_WQ_IsPlaced] = data[CSV_WQ_IsPlaced]

                                #If new data does not include XY information, existing data in GDB will be used
                                if Coord is True:
                                    XY_Point = (data[CSV_ShapeX],data[CSV_ShapeY])
                                    row[GDB_Shape] = XY_Point

                                #update row if geometry is valid
                                try:                                
                                    cursorUpdate.updateRow(row)
                                except:
                                    pass

                                #Updated Features
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name],Type]
                            del cursorUpdate

                        #Add new data
                        else:

                            if Coord is True:

                                Name =  data[CSV_Name]
                                Type = NodeTypeDict[data[CSV_Type]][1]
                                Baseflow = data[CSV_BaseFlow]
                                InitialStage = data[CSV_InitialStage]
                                WarningStage = data[CSV_WarningStage]
                                AlertStage = data[CSV_AlertStage]                                
                                IsPlace = data[CSV_IsPlaced]
                                Parent = ScenDict[data[CSV_ParentID]][1]
                                BoundaryStage = data[CSV_BoundaryStage]
                                Comment = data[CSV_Comment]
                                GUID = data[CSV_ID]
                                XY = (data[CSV_ShapeX],data[CSV_ShapeY])
                                WQ_WQOption = data[CSV_WQ_WQOption]
                                WQ_Comment = data[CSV_WQ_Comment]
                                WQ_ShapeX = data[CSV_WQ_ShapeX]
                                WQ_ShapeY = data[CSV_WQ_ShapeY]
                                WQ_ShapeZ = data[CSV_WQ_ShapeZ]
                                WQ_IsPlaced = data[CSV_WQ_IsPlaced]


                                In_Data =  (Name,
                                            Type,
                                            Baseflow,
                                            InitialStage,
                                            WarningStage,
                                            AlertStage,
                                            IsPlace,
                                            Parent,
                                            BoundaryStage,
                                            Comment,
                                            GUID,
                                            XY,
                                            WQ_WQOption,
                                            WQ_Comment,
                                            WQ_ShapeX,
                                            WQ_ShapeY,
                                            WQ_ShapeZ,
                                            WQ_IsPlaced)

                                #Insert new record if geometry is valid
                                try:
                                    cursorInsert1.insertRow(In_Data)
                                except:
                                    pass

                                #Added features/data
                                AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name],Type]                                

                            else:
                            
                                Name =  data[CSV_Name]
                                Type = NodeTypeDict[data[CSV_Type]][1]
                                Baseflow = data[CSV_BaseFlow]
                                InitialStage = data[CSV_InitialStage]
                                WarningStage = data[CSV_WarningStage]
                                AlertStage = data[CSV_AlertStage]
                                IsPlace = data[CSV_IsPlaced]
                                Parent = ScenDict[data[CSV_ParentID]][1]
                                BoundaryStage = data[CSV_BoundaryStage]
                                Comment = data[CSV_Comment]
                                GUID = data[CSV_ID]
                                WQ_WQOption = data[CSV_WQ_WQOption]
                                WQ_Comment = data[CSV_WQ_Comment]
                                WQ_ShapeX = data[CSV_WQ_ShapeX]
                                WQ_ShapeY = data[CSV_WQ_ShapeY]
                                WQ_ShapeZ = data[CSV_WQ_ShapeZ]
                                WQ_IsPlaced = data[CSV_WQ_IsPlaced]

                                In_Data =  (Name,
                                            Type,
                                            Baseflow,
                                            InitialStage,
                                            WarningStage,
                                            AlertStage,
                                            IsPlace,
                                            Parent,
                                            BoundaryStage,
                                            Comment,
                                            GUID,
                                            WQ_WQOption,
                                            WQ_Comment,
                                            WQ_ShapeX,
                                            WQ_ShapeY,
                                            WQ_ShapeZ,
                                            WQ_IsPlaced)

                                #Insert new record if geometry is valid
                                try:
                                    cursorInsert2.insertRow(In_Data)
                                except:
                                    pass

                                #Added features/data
                                AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name],Type]
                del cursorInsert1
                del cursorInsert2

    except:

        arcpy.GetMessages()

    #Cycle through all data to delete values if required
    with arcpy.da.Editor(path)as edit:

        try:
            if Merge == False:

                cursor = arcpy.da.UpdateCursor(outfc, fields)

                for row in cursor:

                    if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                        cursor.deleteRow()

                del cursor

        except:

            arcpy.GetMessages()

##########################################################################################################################
#Node Stage-Area Table
##########################################################################################################################
        try:
            #Output
            outfc1 = "ICPR_NODE_STORAGE"
            outfc2 = "ICPR_NODE_TIMESTAGE"

            #Input
            infc = infc1 + "\\" + Filestem + "_" + "Node_Point.csv"

            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(outfc1, "CLEAR_SELECTION")
                arcpy.SelectLayerByAttribute_management(outfc2, "CLEAR_SELECTION")

            except:

                pass

            #Delete if merge is false otherwise merge
            try:

                arcpy.DeleteRows_management(outfc1)
                arcpy.DeleteRows_management(outfc2)


            except:

                arcpy.GetMessages()


            #Add data to tables
            try:

                #Create fields
                #Stage Area
                fields1 = ['NAME',
                           'STAGE_VAL',
                           'AREA_MS',
                           'VOLUME_VAL',
                           'ICPR_GUID']

                #Time Stage
                fields2 = ['NAME',
                           'TIME_VAL',
                           'STAGE_VAL',
                           'DAY',
                           'MONTH',
                           'YEAR',
                           'ICPR_GUID']

                with open(infc,'r') as csv_file:
                    first = True
                    cursor1 = arcpy.da.InsertCursor(outfc1, fields1)
                    cursor2 = arcpy.da.InsertCursor(outfc2, fields2)
                    
                    for line in csv_file:
                        if first== True:
                            first = False
                            header_row = iccsv.csv_parseline(line)
                            CSV_ID = header_row.index("ID")
                            CSV_ParentID = header_row.index("ParentID")
                            CSV_Year = header_row.index("Year")
                            CSV_Month = header_row.index("Month")
                            CSV_Day = header_row.index("Day")
                            CSV_X = header_row.index("X")
                            CSV_Y = header_row.index("Y")

                        else:

                            data = iccsv.csv_parseline(line)

                            #Set data formats for non-text used fields
                            data[CSV_Year] = int(data[CSV_Year])
                            data[CSV_Month] = int(data[CSV_Month])
                            data[CSV_Day] = int(data[CSV_Day])
                            data[CSV_X] = float(data[CSV_X])
                            data[CSV_Y] = float(data[CSV_Y])


                            #Stage Area
                            if data[CSV_ParentID] in AddDict and AddDict[data[CSV_ParentID]][2]== 0:

                                GDB_Name = AddDict[data[CSV_ParentID]][1]
                                GDB_STAGE_VAL = data[CSV_X]
                                GDB_AREA_MS = data[CSV_Y]
                                GDB_VOLUME_VAL = None
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_Name,
                                           GDB_STAGE_VAL,
                                           GDB_AREA_MS,
                                           GDB_VOLUME_VAL,
                                           ICPR_GUID]
                                
                                cursor1.insertRow(In_Data)                                

                            #Stage Area
                            if data[CSV_ParentID] in UpDict and UpDict[data[CSV_ParentID]][2]== 0:

                                GDB_Name = UpDict[data[CSV_ParentID]][1]
                                GDB_STAGE_VAL = data[CSV_X]
                                GDB_AREA_MS = data[CSV_Y]
                                GDB_VOLUME_VAL = None
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_Name,
                                           GDB_STAGE_VAL,
                                           GDB_AREA_MS,
                                           GDB_VOLUME_VAL,
                                           ICPR_GUID]
                                
                                cursor1.insertRow(In_Data)                                

                            #Stage Volume
                            if data[CSV_ParentID] in AddDict and AddDict[data[CSV_ParentID]][2]== 2:

                                GDB_Name = AddDict[data[CSV_ParentID]][1]
                                GDB_STAGE_VAL = data[CSV_X]
                                GDB_AREA_MS = None
                                GDB_VOLUME_VAL = data[CSV_Y]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_Name,
                                           GDB_STAGE_VAL,
                                           GDB_AREA_MS,
                                           GDB_VOLUME_VAL,
                                           ICPR_GUID]
                                
                                cursor1.insertRow(In_Data)

                            #Stage Volume
                            if data[CSV_ParentID] in UpDict and UpDict[data[CSV_ParentID]][2]== 2:

                                GDB_Name = UpDict[data[CSV_ParentID]][1]
                                GDB_STAGE_VAL = data[CSV_X]
                                GDB_AREA_MS = None
                                GDB_VOLUME_VAL = data[CSV_Y]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_Name,
                                           GDB_STAGE_VAL,
                                           GDB_AREA_MS,
                                           GDB_VOLUME_VAL,
                                           ICPR_GUID]

                                cursor1.insertRow(In_Data)

                            #Time Stage
                            if data[CSV_ParentID] in AddDict and AddDict[data[CSV_ParentID]][2]== 1:

                                GDB_Name = AddDict[data[CSV_ParentID]][1]
                                GDB_TIME_VAL = data[CSV_X]
                                GDB_STAGE_VAL = data[CSV_Y]
                                GDB_DAY = data[CSV_Day]
                                GDB_MONTH = data[CSV_Month]
                                GDB_YEAR = data[CSV_Year]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_Name,
                                           GDB_TIME_VAL,
                                           GDB_STAGE_VAL,
                                           GDB_DAY,
                                           GDB_MONTH,
                                           GDB_YEAR,
                                           ICPR_GUID]
                                
                                cursor2.insertRow(In_Data)
                                
                            #Time Stage
                            if data[CSV_ParentID] in UpDict and UpDict[data[CSV_ParentID]][2]== 1:

                                GDB_Name = UpDict[data[CSV_ParentID]][1]
                                GDB_TIME_VAL = data[CSV_X]
                                GDB_STAGE_VAL = data[CSV_Y]
                                GDB_DAY = data[CSV_Day]
                                GDB_MONTH = data[CSV_Month]
                                GDB_YEAR = data[CSV_Year]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_Name,
                                           GDB_TIME_VAL,
                                           GDB_STAGE_VAL,
                                           GDB_DAY,
                                           GDB_MONTH,
                                           GDB_YEAR,
                                           ICPR_GUID]
                               
                                cursor2.insertRow(In_Data)
                    del cursor1
                    del cursor2
                    

            except:
                arcpy.GetMessages()

        except:
            arcpy.GetMessages()

##########################################################################################################################
#Node Node WQ
##########################################################################################################################
        try:
            #Output
            outfc = "ICPR4_Node_WQ"

            #Input
            infc = infc1 + "\\" + Filestem + "_" + "Node_WQ.csv"

            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

            except:

                pass

            #Delete if merge is false otherwise merge
            try:
                #Empty Table
                arcpy.DeleteRows_management(outfc)

                #Append new/updated data
                fields = ['Node_Name',
                          'Constituent',
                          'Concentration',
                          'InitialConcentration',
                          'RemovalEfficiency',
                          'ICPR_GUID',
                          'UseDfltInitConcentration',
                          'UseDfltIrrConcentration',
                          'IrreducibleConcentration']

                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                
                with open(infc,'r') as csv_file:
                    first = True
                    for line in csv_file:
                        if first== True:
                            first = False
                            header_row = iccsv.csv_parseline(line)
                            CSV_ID = header_row.index("ID")
                            CSV_ParentID = header_row.index("ParentID")
                            CSV_Constituent = header_row.index("Constituent")
                            CSV_Concentration = header_row.index("Concentration")
                            CSV_InitialConcentration = header_row.index("InitialConcentration")
                            CSV_RemovalEfficiency = header_row.index("RemovalEfficiency")
                            CSV_UseDfltInitConcentration = header_row.index("UseDfltInitConcentration")
                            CSV_UseDfltIrrConcentration = header_row.index("UseDfltIrrConcentration")
                            CSV_IrreducibleConcentration = header_row.index("IrreducibleConcentration")

                        else:

                            data = iccsv.csv_parseline(line)

                            if data[CSV_ParentID] in AddDict:

                                #Add Data
                                GDB_NodeName = AddDict[data[CSV_ParentID]][1]
                                GDB_Constituent = data[CSV_Constituent]
                                GDB_Concentration = data[CSV_Concentration]
                                GDB_InitialConcentration = data[CSV_InitialConcentration]
                                GDB_RemovalEfficiency = data[CSV_RemovalEfficiency]
                                GDB_UseDfltInitConcentration = int(data[CSV_UseDfltInitConcentration])
                                GDB_UseDfltIrrConcentration = int(data[CSV_UseDfltIrrConcentration])
                                GDB_IrreducibleConcentration = float(data[CSV_IrreducibleConcentration])
                                
                                
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_NodeName,
                                           GDB_Constituent,
                                           GDB_Concentration,
                                           GDB_InitialConcentration,
                                           GDB_RemovalEfficiency,
                                           ICPR_GUID,
                                           GDB_UseDfltInitConcentration,
                                           GDB_UseDfltIrrConcentration,
                                           GDB_IrreducibleConcentration]

                                cursorInsert.insertRow(In_Data)

                            if data[CSV_ParentID] in UpDict:

                                #Add Data
                                GDB_NodeName =UpDict[data[CSV_ParentID]][1]
                                GDB_Constituent = data[CSV_Constituent]
                                GDB_Concentration = data[CSV_Concentration]
                                GDB_InitialConcentration = data[CSV_InitialConcentration]
                                GDB_RemovalEfficiency = data[CSV_RemovalEfficiency]
                                ICPR_GUID = data[CSV_ID]
                                GDB_RemovalEfficiency = data[CSV_RemovalEfficiency]
                                GDB_UseDfltInitConcentration = int(data[CSV_UseDfltInitConcentration])
                                GDB_UseDfltIrrConcentration = int(data[CSV_UseDfltIrrConcentration])
                                GDB_IrreducibleConcentration = float(data[CSV_IrreducibleConcentration])

                                In_Data = [GDB_NodeName,
                                           GDB_Constituent,
                                           GDB_Concentration,
                                           GDB_InitialConcentration,
                                           GDB_RemovalEfficiency,
                                           ICPR_GUID,
                                           GDB_UseDfltInitConcentration,
                                           GDB_UseDfltIrrConcentration,
                                           GDB_IrreducibleConcentration]

                                cursorInsert.insertRow(In_Data)

                del cursorInsert

            except:
                arcpy.GetMessages()

        except:
            arcpy.GetMessages()


##########################################################################################################################
#Node external hydrograph
##########################################################################################################################
        try:
            #Output
            outfc = "ICPR4_Node_External_Hydrograph"

            #Input
            infc = infc1 + "\\" + Filestem + "_" + "Node_ExternalHydrograph.csv"

            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

            except:

                pass

            #Delete if merge is false otherwise merge
            try:

                #Empty table
                arcpy.DeleteRows_management(outfc)

                #Append new/updated data
                fields = ['Name',
                           'NodeName',
                           'ICPR_GUID']

                cursorInsert = arcpy.da.InsertCursor(outfc, fields)

                with open(infc,'r') as csv_file:
                    first = True
                    for line in csv_file:
                        if first== True:
                            first = False
                            header_row = iccsv.csv_parseline(line)
                            CSV_ID = header_row.index("ID")
                            CSV_ParentID = header_row.index("ParentID")
                            CSV_ExternalHydrograph = header_row.index("ExternalHydrograph")

                        else:

                            data = iccsv.csv_parseline(line)

                            if data[CSV_ParentID] in AddDict:

                                #Add Data
                                GDB_Name = data[CSV_ExternalHydrograph]
                                GDB_NodeName = AddDict[data[CSV_ParentID]][1]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_Name,
                                           GDB_NodeName,
                                           ICPR_GUID]

                                cursorInsert.insertRow(In_Data)

                            if data[CSV_ParentID] in UpDict:

                                #Add Data
                                GDB_Name = data[CSV_ExternalHydrograph]
                                GDB_NodeName = UpDict[data[CSV_ParentID]][1]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_Name,
                                           GDB_NodeName,
                                           ICPR_GUID]

                                cursorInsert.insertRow(In_Data)

                del cursorInsert

            except:
                arcpy.GetMessages()

        except:
            arcpy.GetMessages()

##########################################################################################################################
#Node external hydrograph WQ
##########################################################################################################################
        try:
            #Output
            outfc = "ICPR4_Node_ExternalHydrograph_WQ"

            #Input
            infc = infc1 + "\\" + Filestem + "_" + "Node_ExternalHydrograph_WQ.csv"

            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

            except:

                pass

            #Delete if merge is false otherwise merge
            try:

                arcpy.DeleteRows_management(outfc)
                
                #Append new/updated data
                fields = ['Node_Name',
                          'ExternalHydrograph',
                          'Constituent',
                          'Concentration',
                          'ICPR_GUID']

                CursorInsert = arcpy.da.InsertCursor(outfc, fields)

                with open(infc,'r') as csv_file:
                    first = True
                    for line in csv_file:
                        if first== True:
                            first = False
                            header_row = iccsv.csv_parseline(line)
                            CSV_ID = header_row.index("ID")
                            CSV_ParentID = header_row.index("ParentID")
                            CSV_ExternalHydrograph = header_row.index("ExternalHydrograph")
                            CSV_Constituent = header_row.index("Constituent")
                            CSV_Concentration = header_row.index("Concentration")

                        else:

                            data = iccsv.csv_parseline(line)

                            if data[CSV_ParentID] in AddDict:

                                #Add Data
                                GDB_NodeName = AddDict[data[CSV_ParentID]][1]
                                GDB_ExternalHydrograph = data[CSV_ExternalHydrograph]
                                GDB_Constituent = data[CSV_Constituent]
                                GDB_Concentration = data[CSV_Concentration]

                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_NodeName,
                                           GDB_ExternalHydrograph,
                                           GDB_Constituent,
                                           GDB_Concentration,
                                           ICPR_GUID]

                                CursorInsert.insertRow(In_Data)

                            if data[CSV_ParentID] in UpDict:

                                #Add Data
                                GDB_NodeName = UpDict[data[CSV_ParentID]][1]
                                GDB_ExternalHydrograph = data[CSV_ExternalHydrograph]
                                GDB_Constituent = data[CSV_Constituent]
                                GDB_Concentration = data[CSV_Concentration]
                                ICPR_GUID = data[CSV_ID]

                                In_Data = [GDB_NodeName,
                                           GDB_ExternalHydrograph,
                                           GDB_Constituent,
                                           GDB_Concentration,
                                           ICPR_GUID]

                                CursorInsert.insertRow(In_Data)

                del CursorInsert

            except:
                arcpy.GetMessages()

        except:
            arcpy.GetMessages()


##########################################################################################################################
#Node Stage-Area Polygon
##########################################################################################################################
        try:
            #Output
            outfc = "Node_Storage_Polygon"

            #Input
            infc = infc1 + "\\" + Filestem + "_" + "Node_Polygon_Point.csv"

            #Clear current selection
            try:
                arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

            except:

                pass

            #Delete existing storage polygons.  Then create new ones.
            try:                

                arcpy.DeleteRows_management(outfc)

                #Append new/updated data
                fields = ['NodeName',
                          'ICPR_GUID',
                          'Shape@']

                cursorInsert = arcpy.da.InsertCursor(outfc, fields)

                #Flags for feature geometry data
                Pnts_done = False
                Pnts = []
                GDB_NodeName = None

                with open(infc,'r') as csv_file:
                    first = True
                    for line in csv_file:
                        if first== True:
                            first = False
                            header_row = iccsv.csv_parseline(line)
                            CSV_ID = header_row.index("ID")
                            CSV_ParentID = header_row.index("ParentID")
                            CSV_Vertex = header_row.index("Vertex")
                            CSV_X = header_row.index("X")
                            CSV_Y = header_row.index("Y")


                        else:

                            data = iccsv.csv_parseline(line)
                            if data[CSV_ParentID] in AddDict:

                                #Check is name new vertex features
                                if GDB_NodeName != AddDict[data[CSV_ParentID]][1] and GDB_NodeName is not None:

                                    Pnts_done = True

                                #When all vertices are read
                                if Pnts_done is True:

                                    #Write out Data complete
                                    In_Data = [GDB_NodeName,
                                               ICPR_GUID,
                                               Pnts]                                               
                                    
                                    #insert if geometry is valid
                                    try:
                                        cursorInsert.insertRow(In_Data)
                                    except:
                                        pass

                                    #Reset values
                                    Pnts_done = False
                                    Pnts = []

                                #Process firt point
                                if Pnts_done is False:

                                    GDB_NodeName = AddDict[data[CSV_ParentID]][1]
                                    ICPR_GUID = data[CSV_ID]

                                    #Add Data
                                    pnt = (data[CSV_X],data[CSV_Y])
                                    Pnts.append(pnt)

                            if data[CSV_ParentID] in UpDict:

                                #Check is name new vertex features
                                if GDB_NodeName != UpDict[data[CSV_ParentID]][1] and GDB_NodeName is not None:

                                    Pnts_done = True

                                #When all vertices are read
                                if Pnts_done is True:

                                    #Write out Data complete
                                    In_Data = [GDB_NodeName,
                                               ICPR_GUID,
                                               Pnts]
                                    
                                    #insert if geometry is valid
                                    try:
                                        cursorInsert.insertRow(In_Data)
                                    except:
                                        pass

                                    #Reset values
                                    Pnts_done = False
                                    Pnts = []

                                #Process point
                                if Pnts_done is False:

                                    GDB_NodeName = UpDict[data[CSV_ParentID]][1]
                                    ICPR_GUID = data[CSV_ID]

                                    #Add Data
                                    pnt = (data[CSV_X],data[CSV_Y])
                                    Pnts.append(pnt)


                    #Write out last feature data
                    try:

                        #Write out Data complete
                        In_Data = [GDB_NodeName,
                                   ICPR_GUID,
                                   Pnts]
                                   
                       
                        #insert if geometry is valid
                        try:
                            cursorInsert.insertRow(In_Data)
                        except:
                            pass

                    except:

                        arcpy.GetMessages()


                del cursorInsert

            except:
                arcpy.GetMessages()

        except:
            arcpy.GetMessages()

