#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Link module
##########################################################################################################################
def UpdateLink(infc1, Merge, Filestem, LinkTypeDict,ScenDict):


##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    #Add temp fields to CHANNEL, WEIR and PIPE BARREL Tables.

    try:

        #Output
        outfc = "ICPR_LINK"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link.csv"


        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Add temp field for teo retain ICPR link name
        ##############
        ##CHANNEL
        ##############
        try:
            arcpy.AddField_management(in_table="CHANNEL", field_name="TEMP_123", field_type="TEXT", field_precision="",\
                                      field_scale="", field_length="500", field_alias="", field_is_nullable="NULLABLE", \
                                      field_is_required="NON_REQUIRED", field_domain="")

            arcpy.AddMessage("CHANNEL Table: Added temporary TEMP_123 field")

        except:

            arcpy.AddMessage("CHANNEL Table: Temporary TEMP_123 field already exists")
        #######
        ##PIPE
        #######
        try:
            arcpy.AddField_management(in_table="PIPE_BARREL", field_name="TEMP_123", field_type="TEXT", field_precision="",\
                                      field_scale="", field_length="500", field_alias="", field_is_nullable="NULLABLE", \
                                      field_is_required="NON_REQUIRED", field_domain="")

            arcpy.AddMessage("PIPE_BARREL Table: Added temporary TEMP_123 field")

        except:

            arcpy.AddMessage("PIPE_BARREL Table: Temporary TEMP_123 field already exists")
        #######
        ##WEIR
        #######
        try:
            arcpy.AddField_management(in_table="WEIR", field_name="TEMP_123", field_type="TEXT", field_precision="",\
                                      field_scale="", field_length="500", field_alias="", field_is_nullable="NULLABLE", \
                                      field_is_required="NON_REQUIRED", field_domain="")

            arcpy.AddMessage("WEIR Table: Added temporary TEMP_123 field")

        except:

            arcpy.AddMessage("WEIR Table: Temporary TEMP_123 field already exists")

        #Calc temp fields to retain names
        arcpy.CalculateField_management(in_table="CHANNEL", field="TEMP_123", expression="!ICPR_LINK_NAME!", expression_type="PYTHON", code_block="")
        arcpy.CalculateField_management(in_table="PIPE_BARREL", field="TEMP_123", expression="!ICPR_LINK_NAME!", expression_type="PYTHON", code_block="")
        arcpy.CalculateField_management(in_table="WEIR", field="TEMP_123", expression="!ICPR_LINK_NAME!", expression_type="PYTHON", code_block="")

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'TYPE',
                  'FROM_NODE',
                  'TO_NODE',
                  'FLOW',
                  'ISPLACED',
                  'SCENARIO',
                  'LINKCOUNT',
                  'COMMENT',
                  'ICPR_GUID',
                  'SHAPEISCLOSED',
                  'WQ_WQOption',
                  'WQ_Comment',
                  'WQ_ShapeX',
                  'WQ_ShapeY',
                  'WQ_ShapeZ',
                  'WQ_IsPlaced']


        #List index
        GDB_NAME = fields.index('NAME')
        GDB_TYPE = fields.index('TYPE')
        GDB_FROM_NODE = fields.index('FROM_NODE')
        GDB_TO_NODE = fields.index('TO_NODE')
        GDB_FLOW = fields.index('FLOW')
        GDB_ISPLACED = fields.index('ISPLACED')
        GDB_SCENARIO = fields.index('SCENARIO')
        GDB_LINKCOUNT = fields.index('LINKCOUNT')
        GDB_COMMENT = fields.index('COMMENT')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_SHAPEISCLOSED = fields.index('SHAPEISCLOSED')
        GDB_WQ_WQOption = fields.index('WQ_WQOption')
        GDB_WQ_Comment = fields.index('WQ_Comment')
        GDB_WQ_ShapeX = fields.index('WQ_ShapeX')
        GDB_WQ_ShapeY = fields.index('WQ_ShapeY')
        GDB_WQ_ShapeZ = fields.index('WQ_ShapeZ')
        GDB_WQ_IsPlaced = fields.index('WQ_IsPlaced')



        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Check if geometric network exists
        desc = arcpy.Describe("Model")
        path = desc.path

        #List data in dataset
        C_List = desc.Children
        del desc

        #Check for geometric network
        try:

            for C in C_List:
                in_file = path + "\\" + "Model" + "\\" + C.baseName

                desc = arcpy.Describe(in_file)
                if desc.dataType == "GeometricNetwork":
                    arcpy.Delete_management(in_file)

        except:
            arcpy.GetMessages()

        #Read CSV Data
        with arcpy.da.Editor(path)as edit:

            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)
                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_Type = header_row.index("Type")
                        CSV_Node_From = header_row.index("Node_From")
                        CSV_Node_To = header_row.index("Node_To")
                        CSV_LinkCount = header_row.index("LinkCount")
                        CSV_FlowDirection = header_row.index("FlowDirection")
                        CSV_Comment = header_row.index("Comment")
                        CSV_IsPlaced = header_row.index("IsPlaced")
                        CSV_ShapeIsClosed = header_row.index("ShapeIsClosed")
                        CSV_WQ_WQOption = header_row.index("WQ_WQOption")
                        CSV_WQ_Comment = header_row.index("WQ_Comment")
                        CSV_WQ_ShapeX = header_row.index("WQ_ShapeX")
                        CSV_WQ_ShapeY = header_row.index("WQ_ShapeY")
                        CSV_WQ_ShapeZ = header_row.index("WQ_ShapeZ")
                        CSV_WQ_IsPlaced = header_row.index("WQ_IsPlaced")

                    else:

                        data = iccsv.csv_parseline(line)

                        #Set data formats for non-text used fields
                        data[CSV_Type] = int(data[CSV_Type])
                        data[CSV_LinkCount] = int(data[CSV_LinkCount])
                        data[CSV_FlowDirection] = int(data[CSV_FlowDirection])
                        data[CSV_IsPlaced] = int(data[CSV_IsPlaced])
                        data[CSV_ShapeIsClosed] = int(data[CSV_ShapeIsClosed])
                        data[CSV_WQ_WQOption] = int(data[CSV_WQ_WQOption])
                        data[CSV_WQ_IsPlaced] = int(data[CSV_WQ_IsPlaced])
                        data[CSV_WQ_ShapeX] = float(data[CSV_WQ_ShapeX])
                        data[CSV_WQ_ShapeY] = float(data[CSV_WQ_ShapeY])
                        data[CSV_WQ_ShapeZ] = float(data[CSV_WQ_ShapeZ])

                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"

                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break

                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                row[GDB_NAME] = data[CSV_Name]
                                row[GDB_TYPE]=LinkTypeDict[data[CSV_Type]]
                                row[GDB_FROM_NODE]=data[CSV_Node_From]
                                row[GDB_TO_NODE]=data[CSV_Node_To]
                                row[GDB_FLOW]=data[CSV_FlowDirection]
                                row[GDB_ISPLACED]=data[CSV_IsPlaced]
                                row[GDB_SCENARIO]=ScenDict[data[CSV_ParentID]][1]
                                row[GDB_LINKCOUNT]=data[CSV_LinkCount]
                                row[GDB_COMMENT]=data[CSV_Comment]
                                row[GDB_ICPR_GUID]=data[CSV_ID]
                                row[GDB_SHAPEISCLOSED]=data[CSV_ShapeIsClosed]
                                row[GDB_WQ_WQOption]=data[CSV_WQ_WQOption]
                                row[GDB_WQ_Comment]=data[CSV_WQ_Comment]
                                row[GDB_WQ_ShapeX]=data[CSV_WQ_ShapeX]
                                row[GDB_WQ_ShapeY]=data[CSV_WQ_ShapeY]
                                row[GDB_WQ_ShapeZ]=data[CSV_WQ_ShapeZ]
                                row[GDB_WQ_IsPlaced]=data[CSV_WQ_IsPlaced]

                                #update row if geometry is valid
                                try:
                                    cursorUpdate.updateRow(row)
                                except:
                                    pass

                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name],data[CSV_Type],row[GDB_ISPLACED]]
                            del cursorUpdate


                        #Add new data
                        else:                            

                            NAME =  data[CSV_Name]
                            TYPE = LinkTypeDict[data[CSV_Type]]
                            FROM_NODE = data[CSV_Node_From]
                            TO_NODE = data[CSV_Node_To]
                            FLOW = data[CSV_FlowDirection]
                            ISPLACED = data[CSV_IsPlaced]
                            SCENARIO = ScenDict[data[CSV_ParentID]][1]
                            LINKCOUNT = data[CSV_LinkCount]
                            COMMENT = data[CSV_Comment]
                            ICPR_GUID = data[CSV_ID]
                            SHAPEISCLOSED = data[CSV_ShapeIsClosed]
                            WQ_WQOption = data[CSV_WQ_WQOption]
                            COMMENT_WQ = data[CSV_WQ_Comment]
                            WQ_ShapeX = data[CSV_WQ_ShapeX]
                            WQ_ShapeY = data[CSV_WQ_ShapeY]
                            WQ_ShapeZ = data[CSV_WQ_ShapeZ]
                            WQ_IsPlaced = data[CSV_WQ_IsPlaced]

                            In_Data = (NAME,
                                       TYPE,
                                       FROM_NODE,
                                       TO_NODE,
                                       FLOW,
                                       ISPLACED,
                                       SCENARIO,
                                       LINKCOUNT,
                                       COMMENT,
                                       ICPR_GUID,
                                       SHAPEISCLOSED,
                                       WQ_WQOption,
                                       COMMENT_WQ,
                                       WQ_ShapeX,
                                       WQ_ShapeY,
                                       WQ_ShapeZ,
                                       WQ_IsPlaced)

                            #Insert new record if geometry is valid
                            try:
                                cursorInsert.insertRow(In_Data)
                            except:
                                pass

                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID],data[CSV_Name],data[CSV_Type]]
                del cursorInsert

        #Cycle through all data to delete values if required
        with arcpy.da.Editor(path)as edit:

            try:
                if Merge == False:

                    cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)

                    for row in cursorUpdate:

                        if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict:

                            cursorUpdate.deleteRow()

                    del cursorUpdate

            except:

                arcpy.GetMessages()

    ##########################################################################################################################
    #Populated Geometry
    ##########################################################################################################################
            try:
                #Output
                outfc = "ICPR_LINK"

                #Input
                infc = infc1 + "\\" + Filestem + "_" + "Link_Shape_Point.csv"

                #Clear current selection
                try:
                    arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

                except:

                    pass

                #Delete if merge is false otherwise merge
                try:                    

                    #Flags for feature geometry data
                    Pnts_done = False
                    Pnts = []
                    Guid_Old = None
                    GeomDict = {}#geometry dicationary
                                                            
                    
                    with open(infc,'r') as csv_file:
                        first = True
                        for line in csv_file:
                            if first== True:
                                first = False
                                header_row = iccsv.csv_parseline(line)
                                CSV_ID = header_row.index("ID")
                                CSV_ParentID = header_row.index("ParentID")
                                CSV_Vertex = header_row.index("Vertex")
                                CSV_X = header_row.index("X")
                                CSV_Y = header_row.index("Y")
                                
                            else:

                                data = iccsv.csv_parseline(line)
                                Guid_New = data[CSV_ParentID]
                                
                                #Initialize old GUID.  Only happens during the first pass.
                                if Guid_Old == None:
                                    Guid_Old = data[CSV_ParentID]
                                
                                #Check if point array is done
                                if Guid_Old != Guid_New:                                                     
                                    
                                    GeomDict[Guid_Old] = Pnts #update dictionary values each time it reads a new record.                                                                        
                                    Guid_Old = Guid_New #Reset old GUID
                                    Pnts = [] #Empty array
                                    
                                    
                                
                                #Create point
                                pnt = (data[CSV_X],data[CSV_Y])
                                Pnts.append(pnt)                                
                
                    #Add last record to dictionary
                    GeomDict[Guid_New] = Pnts #update dictionary values each time it reads a new record.             
                    
                except:
                
                    arcpy.GetMessages()
                
                #Write geometry data to feature class           
                fields = ['ICPR_GUID',
                          'Shape@']

                GDB_ICPR_GUID = fields.index('ICPR_GUID')
                GDB_SHAPE = fields.index('Shape@')
                
                cursorUpdate = arcpy.da.UpdateCursor(outfc,fields)       
                for row in cursorUpdate:
                    try:
                        Guid = row[GDB_ICPR_GUID]
                        Geom = GeomDict[Guid]
                        
                        #add geometry
                        row[GDB_SHAPE] = Geom
                        cursorUpdate.updateRow(row)
                        
                    except:
                        continue

                del cursorUpdate


            except:
                arcpy.GetMessages()

        #Calc temp fields to retain names
        arcpy.CalculateField_management(in_table="CHANNEL", field="ICPR_LINK_NAME", expression="!TEMP_123!", expression_type="PYTHON", code_block="")
        arcpy.CalculateField_management(in_table="PIPE_BARREL", field="ICPR_LINK_NAME", expression="!TEMP_123!", expression_type="PYTHON", code_block="")
        arcpy.CalculateField_management(in_table="WEIR", field="ICPR_LINK_NAME", expression="!TEMP_123!", expression_type="PYTHON", code_block="")


        #Delete temp fields to retain ICPR link names
        arcpy.DeleteField_management(in_table="CHANNEL", drop_field="TEMP_123")
        arcpy.DeleteField_management(in_table="PIPE_BARREL", drop_field="TEMP_123")
        arcpy.DeleteField_management(in_table="WEIR", drop_field="TEMP_123")
            
    except:
        arcpy.GetMessages()
        
    #Return values
    try:
        return AddDict, UpDict

    except:
        arcpy.GetMessages()




