#Copyright 2020 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Link WQ module
##########################################################################################################################
def UpdateLinkWQ(infc1, Merge, Filestem, LAddDict, LUpDict):

##########################################################################################################################
#Update attribute table data and no geometry data - Weirs
##########################################################################################################################
    try:

        #Output
        outfc = "ICPR4_Link_WQ"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_WQ.csv"


        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Fields for update of existing elements/features
        fields = ['Link_Name',
                  'Constituent',
                  'PosRemovalEfficiency',
                  'NegRemovalEfficiency',
                  'ICPR_GUID',
                  'UseDfltIrrConcentration',
                  'IrreducibleConcentration']

        #List index
        GDB_Link_Name = fields.index('Link_Name')
        GDB_Constituent = fields.index('Constituent')
        GDB_PosRemovalEfficiency = fields.index('PosRemovalEfficiency')
        GDB_NegRemovalEfficiency = fields.index('NegRemovalEfficiency')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_UseDfltIrrConcentration = fields.index('UseDfltIrrConcentration')
        GDB_IrreducibleConcentration = fields.index('IrreducibleConcentration')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Constituent = header_row.index("Constituent")
                        CSV_PosRemovalEfficiency = header_row.index("PosRemovalEfficiency")
                        CSV_NegRemovalEfficiency = header_row.index("NegRemovalEfficiency")
                        CSV_UseDfltIrrConcentration = header_row.index("UseDfltIrrConcentration")
                        CSV_IrreducibleConcentration = header_row.index("IrreducibleConcentration")

                    else:

                        data = iccsv.csv_parseline(line)

                        #Set data formats for non-text used fields
                        data[CSV_PosRemovalEfficiency] = float(data[CSV_PosRemovalEfficiency])
                        data[CSV_NegRemovalEfficiency] = float(data[CSV_NegRemovalEfficiency])
                        data[CSV_UseDfltIrrConcentration] = int(data[CSV_UseDfltIrrConcentration])
                        data[CSV_IrreducibleConcentration] = float(data[CSV_IrreducibleConcentration])

                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:

                            i = i + 1
                            if i >=1:
                                break

                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                ##################################
                                #Process data for direct transfer
                                ##################################

                                row[GDB_Constituent] = data[CSV_Constituent]
                                row[GDB_PosRemovalEfficiency] = data[CSV_PosRemovalEfficiency]
                                row[GDB_NegRemovalEfficiency] = data[CSV_NegRemovalEfficiency]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_UseDfltIrrConcentration] = data[CSV_UseDfltIrrConcentration]
                                row[GDB_IrreducibleConcentration] = data[CSV_IrreducibleConcentration]

                                #################################
                                #Assign Link name
                                #################################
                                try:
                                    row[GDB_Link_Name] = LUpDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_Link_Name] = LAddDict[data[CSV_ParentID]][1]

                                ##################################
                                #Process data for direct transfer
                                ##################################
                                #update row
                                cursorUpdate.updateRow(row)

                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID]]

                            del cursorUpdate

                        ###############
                        #Add new data
                        ###############
                        else:
                            
                            ##################################
                            #Process data for direct transfer
                            ##################################

                            Constituent = data[CSV_Constituent]
                            PosRemovalEfficiency = data[CSV_PosRemovalEfficiency]
                            NegRemovalEfficiency = data[CSV_NegRemovalEfficiency]
                            ICPR_GUID = data[CSV_ID]
                            UseDfltIrrConcentration = data[CSV_UseDfltIrrConcentration]
                            IrreducibleConcentration = data[CSV_IrreducibleConcentration]
                            

                            #################################
                            #Assign Link name
                            #################################
                            try:
                                Link_Name = LUpDict[data[CSV_ParentID]][1]
                            except:
                                Link_Name = LAddDict[data[CSV_ParentID]][1]

                            ##################################
                            #Process data for direct transfer
                            ##################################

                            #New Record Data
                            In_Data = [Link_Name,
                                       Constituent,
                                       PosRemovalEfficiency,
                                       NegRemovalEfficiency,
                                       ICPR_GUID,
                                       UseDfltIrrConcentration,
                                       IrreducibleConcentration]

                            #Insert new record
                            cursorInsert.insertRow(In_Data)
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID]]
                            
                del cursorInsert

    except:
        arcpy.GetMessages()

    #Cycle through all data to delete values if required
    try:
        if Merge == False:

            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)

            for row in cursorUpdate:

                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict and len(row[GDB_Link_Name])>0:

                    cursorUpdate.deleteRow()

            del cursorUpdate
    except:
        arcpy.GetMessages()
