#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Pipe module
##########################################################################################################################
def UpdateFrenchDrains(infc1, Merge, Filestem, LAddDict, LUpDict,PipeGeomCode):


##########################################################################################################################
#Update attribute table data and no geometry data
##########################################################################################################################
    try:
        
        #Output
        outfc = "ICPR_EXFILTRATIONTRENCH"    

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_FrenchDrain.csv"        
        

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")
            
        except:
            
            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'TRENCHWIDTH_MS',
                  'TRENCHLENGTH_MS',
                  'TRENCHHEIGHT_MS',
                  'GRAVELPOROSITY_VAL',
                  'OverlandFlowRegion',
                  'GroundwaterRegion',
                  'MeshScalingFactor',
                  'TrenchDepthBelowInvert',
                  'DampeningThreshold',
                  'FHWACulvertCode',
                  'EntranceLossCoef',
                  'ExitLossCoef',
                  'BendLossCoef',
                  'BendLocation',
                  'PipeLength',
                  'UsPipeInvert',
                  'DsPipeInvert',
                  'ManningsN',
                  'PipeMaxDepth',
                  'PipeMaxWidth',
                  'PipeFillet',
                  'PipeCrossSection',
                  'EnergySwitch',
                  'PipeGeometry',
                  'ICPR_GUID']
                  
        #List index 
        GDB_NAME = fields.index('NAME')
        GDB_TRENCHWIDTH_MS = fields.index('TRENCHWIDTH_MS')
        GDB_TRENCHLENGTH_MS = fields.index('TRENCHLENGTH_MS')
        GDB_TRENCHHEIGHT_MS = fields.index('TRENCHHEIGHT_MS')
        GDB_GRAVELPOROSITY_VAL = fields.index('GRAVELPOROSITY_VAL')
        GDB_OverlandFlowRegion = fields.index('OverlandFlowRegion')
        GDB_GroundwaterRegion = fields.index('GroundwaterRegion')
        GDB_MeshScalingFactor = fields.index('MeshScalingFactor')
        GDB_TrenchDepthBelowInvert = fields.index('TrenchDepthBelowInvert')
        GDB_DampeningThreshold = fields.index('DampeningThreshold')
        GDB_FHWACulvertCode = fields.index('FHWACulvertCode')
        GDB_EntranceLossCoef = fields.index('EntranceLossCoef')
        GDB_ExitLossCoef = fields.index('ExitLossCoef')
        GDB_BendLossCoef = fields.index('BendLossCoef')
        GDB_BendLocation = fields.index('BendLocation')
        GDB_PipeLength = fields.index('PipeLength')
        GDB_UsPipeInvert = fields.index('UsPipeInvert')
        GDB_DsPipeInvert = fields.index('DsPipeInvert')
        GDB_ManningsN = fields.index('ManningsN')
        GDB_PipeMaxDepth = fields.index('PipeMaxDepth')
        GDB_PipeMaxWidth = fields.index('PipeMaxWidth')
        GDB_PipeFillet = fields.index('PipeFillet')
        GDB_PipeCrossSection = fields.index('PipeCrossSection')
        GDB_EnergySwitch = fields.index('EnergySwitch')
        GDB_PipeGeometry = fields.index('PipeGeometry')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')        

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

        #Read CSV Data            
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_OverlandFlowRegion = header_row.index("OverlandFlowRegion")
                        CSV_GroundwaterRegion = header_row.index("GroundwaterRegion")
                        CSV_MeshScalingFactor = header_row.index("MeshScalingFactor")
                        CSV_TrenchLength = header_row.index("TrenchLength")
                        CSV_TrenchWidth = header_row.index("TrenchWidth")
                        CSV_TrenchHeight = header_row.index("TrenchHeight")
                        CSV_TrenchDepthBelowInvert = header_row.index("TrenchDepthBelowInvert")
                        CSV_TrenchGravelPorosity = header_row.index("TrenchGravelPorosity")
                        CSV_DampeningThreshold = header_row.index("DampeningThreshold")
                        CSV_FHWACulvertCode = header_row.index("FHWACulvertCode")
                        CSV_EntranceLossCoef = header_row.index("EntranceLossCoef")
                        CSV_ExitLossCoef = header_row.index("ExitLossCoef")
                        CSV_BendLossCoef = header_row.index("BendLossCoef")
                        CSV_BendLocation = header_row.index("BendLocation")
                        CSV_EnergySwitch = header_row.index("EnergySwitch")
                        CSV_PipeLength = header_row.index("PipeLength")
                        CSV_UsPipeInvert = header_row.index("UsPipeInvert")
                        CSV_DsPipeInvert = header_row.index("DsPipeInvert")
                        CSV_ManningsN = header_row.index("ManningsN")
                        CSV_PipeGeometry = header_row.index("PipeGeometry")
                        CSV_PipeMaxDepth = header_row.index("PipeMaxDepth")
                        CSV_PipeMaxWidth = header_row.index("PipeMaxWidth")
                        CSV_PipeFillet = header_row.index("PipeFillet")
                        CSV_PipeCrossSection = header_row.index("PipeCrossSection")

                    else:
                        
                        data = iccsv.csv_parseline(line)
                        
                        #Set data formats for non-text used fields
                        data[CSV_MeshScalingFactor] = float(data[CSV_MeshScalingFactor])
                        data[CSV_TrenchLength] = float(data[CSV_TrenchLength])
                        data[CSV_TrenchWidth] = float(data[CSV_TrenchWidth])
                        data[CSV_TrenchHeight] = float(data[CSV_TrenchHeight])
                        data[CSV_TrenchDepthBelowInvert] = float(data[CSV_TrenchDepthBelowInvert])
                        data[CSV_TrenchGravelPorosity] = float(data[CSV_TrenchGravelPorosity])
                        data[CSV_DampeningThreshold] = float(data[CSV_DampeningThreshold])
                        data[CSV_FHWACulvertCode] = int(data[CSV_FHWACulvertCode])
                        data[CSV_EntranceLossCoef] = float(data[CSV_EntranceLossCoef])
                        data[CSV_ExitLossCoef] = float(data[CSV_ExitLossCoef])
                        data[CSV_BendLossCoef] = float(data[CSV_BendLossCoef])
                        data[CSV_BendLocation] = float(data[CSV_BendLocation])
                        data[CSV_EnergySwitch] = float(data[CSV_EnergySwitch])
                        data[CSV_PipeLength] = float(data[CSV_PipeLength])
                        data[CSV_UsPipeInvert] = float(data[CSV_UsPipeInvert])
                        data[CSV_DsPipeInvert] = float(data[CSV_DsPipeInvert])
                        data[CSV_ManningsN] = float(data[CSV_ManningsN])
                        data[CSV_PipeGeometry] = int(data[CSV_PipeGeometry])
                        data[CSV_PipeMaxDepth] = float(data[CSV_PipeMaxDepth])
                        data[CSV_PipeMaxWidth] = float(data[CSV_PipeMaxWidth])
                        data[CSV_PipeFillet] = float(data[CSV_PipeFillet])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                                    
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
             
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:
                            i = i + 1
                            if i >=1:
                                break
                            
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                ########################                           
                                #Determine Span
                                ########################
                                #Cirular
                                if PipeGeomCode[data[CSV_PipeGeometry]] == 0:
                                    
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*1

                                #Horizontal Ellipse
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 1:
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*1.56
                                    
                                #Vertical Ellipse
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 2:
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*(1/1.56)
                                
                                #Egg Shaped    
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 8:
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*(2/3)

                                #Horseshoe    
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 9:
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*1

                                #Gothic    
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 10:
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*0.84

                                #Catenary    
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 11:
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*0.9

                                #Basket Handle    
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 12:
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*0.944

                                #Semi-Circular    
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 13:
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*1.64
                                    
                                #Semi-Elliptical    
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 14:
                                    
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxDepth]*12*1
                                    
                                #Con Span    
                                elif PipeGeomCode[data[CSV_PipeGeometry]] == 18:
                                    row[GDB_PipeMaxDepth] = None
                                    row[GDB_PipeMaxWidth] = None

                                #Arch/Rectangular/V-Notch
                                else:
                                    row[GDB_PipeMaxDepth] = data[CSV_PipeMaxDepth]*12
                                    row[GDB_PipeMaxWidth] = data[CSV_PipeMaxWidth]*12                                


                                #################################
                                #Assign Link name
                                #################################
                                try:
                                    row[GDB_NAME] = LUpDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_NAME] = LAddDict[data[CSV_ParentID]][1]
                                    
                                ##################################    
                                #Process data for direct transfer
                                ##################################
                                row[GDB_PipeGeometry] = PipeGeomCode[data[CSV_PipeGeometry]]                            
                                row[GDB_TRENCHWIDTH_MS] = data[CSV_TrenchWidth]
                                row[GDB_TRENCHLENGTH_MS] = data[CSV_TrenchLength]
                                row[GDB_TRENCHHEIGHT_MS] = data[CSV_TrenchHeight]
                                row[GDB_GRAVELPOROSITY_VAL] = data[CSV_TrenchGravelPorosity]
                                row[GDB_OverlandFlowRegion] = data[CSV_OverlandFlowRegion]
                                row[GDB_GroundwaterRegion] = data[CSV_GroundwaterRegion]
                                row[GDB_MeshScalingFactor] = data[CSV_MeshScalingFactor]
                                row[GDB_TrenchDepthBelowInvert] = data[CSV_TrenchDepthBelowInvert]
                                row[GDB_DampeningThreshold] = data[CSV_DampeningThreshold]
                                row[GDB_FHWACulvertCode] = data[CSV_FHWACulvertCode]
                                row[GDB_EntranceLossCoef] = data[CSV_ExitLossCoef]
                                row[GDB_ExitLossCoef] = data[CSV_ExitLossCoef]
                                row[GDB_BendLossCoef] = data[CSV_BendLossCoef]
                                row[GDB_BendLocation] = data[CSV_BendLocation]
                                row[GDB_PipeLength] = data[CSV_PipeLength]
                                row[GDB_UsPipeInvert] = data[CSV_UsPipeInvert]
                                row[GDB_DsPipeInvert] = data[CSV_DsPipeInvert]
                                row[GDB_ManningsN] = data[CSV_ManningsN]
                                row[GDB_PipeFillet] = data[CSV_PipeFillet]
                                row[GDB_PipeCrossSection] = data[CSV_PipeCrossSection]
                                row[GDB_EnergySwitch] = data[CSV_EnergySwitch]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                
                                #update row
                                cursorUpdate.updateRow(row)
                                
                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID]]
                            del cursorUpdate                           
                                
                        ###############
                        #Add new data
                        ###############
                        else:

                            ########################                           
                            #Determine Span
                            ########################
                            #Cirular
                            if PipeGeomCode[data[CSV_PipeGeometry]] == 0:
                                
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*1

                            #Horizontal Ellipse
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 1:
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*1.56
                                
                            #Vertical Ellipse
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 2:
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*(1/1.56)
                            
                            #Egg Shaped    
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 8:
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*(2/3)

                            #Horseshoe    
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 9:
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*1

                            #Gothic    
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 10:
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*0.84

                            #Catenary    
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 11:
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*0.9

                            #Basket Handle    
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 12:
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*0.944

                            #Semi-Circular    
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 13:
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*1.64
                                
                            #Semi-Elliptical    
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 14:
                                
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxDepth]*12*1
                                
                            #Con Span    
                            elif PipeGeomCode[data[CSV_PipeGeometry]] == 18:
                                PipeMaxDepth = None
                                PipeMaxWidth = None

                            #Arch/Rectangular/V-Notch
                            else:
                                PipeMaxDepth = data[CSV_PipeMaxDepth]*12
                                PipeMaxWidth = data[CSV_PipeMaxWidth]*12                                


                            #################################
                            #Assign Link name
                            #################################
                            try:
                                NAME = LUpDict[data[CSV_ParentID]][1]
                            except:
                                NAME = LAddDict[data[CSV_ParentID]][1]
                                
                            ##################################    
                            #Process data for direct transfer
                            ##################################
                            PipeGeometry = PipeGeomCode[data[CSV_PipeGeometry]]                            
                            TRENCHWIDTH_MS = data[CSV_TrenchWidth]
                            TRENCHLENGTH_MS = data[CSV_TrenchLength]
                            TRENCHHEIGHT_MS = data[CSV_TrenchHeight]
                            GRAVELPOROSITY_VAL = data[CSV_TrenchGravelPorosity]
                            OverlandFlowRegion = data[CSV_OverlandFlowRegion]
                            GroundwaterRegion = data[CSV_GroundwaterRegion]
                            MeshScalingFactor = data[CSV_MeshScalingFactor]
                            TrenchDepthBelowInvert = data[CSV_TrenchDepthBelowInvert]
                            DampeningThreshold = data[CSV_DampeningThreshold]
                            FHWACulvertCode = data[CSV_FHWACulvertCode]
                            EntranceLossCoef = data[CSV_ExitLossCoef]
                            ExitLossCoef = data[CSV_ExitLossCoef]
                            BendLossCoef = data[CSV_BendLossCoef]
                            BendLocation = data[CSV_BendLocation]
                            PipeLength = data[CSV_PipeLength]
                            UsPipeInvert = data[CSV_UsPipeInvert]
                            DsPipeInvert = data[CSV_DsPipeInvert]
                            ManningsN = data[CSV_ManningsN]
                            PipeFillet = data[CSV_PipeFillet]
                            PipeCrossSection = data[CSV_PipeCrossSection]
                            EnergySwitch = data[CSV_EnergySwitch]
                            ICPR_GUID = data[CSV_ID]

                            #New Record Data
                            In_Data = (NAME,
                                       TRENCHWIDTH_MS,
                                       TRENCHLENGTH_MS,
                                       TRENCHHEIGHT_MS,
                                       GRAVELPOROSITY_VAL,
                                       OverlandFlowRegion,
                                       GroundwaterRegion,
                                       MeshScalingFactor,
                                       TrenchDepthBelowInvert,
                                       DampeningThreshold,
                                       FHWACulvertCode,
                                       EntranceLossCoef,
                                       ExitLossCoef,
                                       BendLossCoef,
                                       BendLocation,
                                       PipeLength,
                                       UsPipeInvert,
                                       DsPipeInvert,
                                       ManningsN,
                                       PipeMaxDepth,
                                       PipeMaxWidth,
                                       PipeFillet,
                                       PipeCrossSection,
                                       EnergySwitch,
                                       PipeGeometry,
                                       ICPR_GUID) 

                            #Insert new record                        
                            cursorInsert.insertRow(In_Data)
                                             
                            
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID]]            
                del cursorInsert
                   
    except:
        arcpy.GetMessages()
        
    #Cycle through all data to delete values if required
    try:

        if Merge == False:
            
            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)
            
            for row in cursorUpdate:
                
                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict and len(row[GDB_NAME])>0:

                    cursorUpdate.deleteRow()

            del cursorUpdate

    except:        
        arcpy.GetMessages()
