#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Pipe module
##########################################################################################################################
def UpdateDrop(infc1, Merge, Filestem, LAddDict, LUpDict,PipeGeomCode,WeirOrienDict,WeirGeomDict):


##########################################################################################################################
#Update attribute table data and no geometry data - Drop Pipes
##########################################################################################################################
    try:

        #Output
        outfc = "PIPE_BARREL"
        outfc2 = "DROP_STRUCTURE"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_DropStructure.csv"


        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Fields for update of existing elements/features
        fields = ['UPSTREAM_SHAPE_DESC',
                  'UPSTREAM_INVERT_ELEVATION_MS',
                  'UPSTREAM_RISE_MS',
                  'UPSTREAM_SPAN_MS',
                  'UPSTREAM_MANNINGSN_VAL',
                  'UPSTREAM_INLET_DESC',
                  'UPSTREAM_CROSS_SECTION',
                  'UPSTREAM_TOPCLIP_MS',
                  'UPSTREAM_TOPCLIP_MANNINGSN',
                  'UPSTREAM_TOPCLIP_OPTABLE',
                  'UPSTREAM_TOPCLIP_NODE',
                  'UPSTREAM_BOTTOMCLIP_MS',
                  'UPSTREAM_BOTTOMCLIP_MANNINGSN',
                  'UPSTREAM_BOTTOMCLIP_OPTABLE',
                  'UPSTREAM_BOTTOMCLIP_NODE',
                  'UPSTREAM_FILLET',
                  'DOWNSTREAM_SHAPE_DESC',
                  'DOWNSTREAM_INVERT_ELEVATION_MS',
                  'DOWNSTREAM_RISE_MS',
                  'DOWNSTREAM_SPAN_MS',
                  'DOWNSTREAM_MANNINGSN_VAL',
                  'DOWNSTREAM_INLET_DESC',
                  'DOWNSTREAM_CROSS_SECTION',
                  'DOWNSTREAM_TOPCLIP_MS',
                  'DOWNSTREAM_TOPCLIP_MANNINGSN',
                  'DOWNSTREAM_TOPCLIP_OPTABLE',
                  'DOWNSTREAM_TOPCLIP_NODE',
                  'DOWNSTREAM_BOTTOMCLIP_MS',
                  'DOWNSTREAM_BOTTOMCLIP_MANNINGSN',
                  'DOWNSTREAM_BOTTOMCLIP_OPTABLE',
                  'DOWNSTREAM_BOTTOMCLIP_NODE',
                  'DOWNSTREAM_FILLET',
                  'PIPE_BARREL_LENGTH_MS',
                  'ENTRANCE_LOSS_VAL',
                  'EXIT_LOSS_VAL',
                  'BEND_LOSS_VAL',
                  'SUBELEMENT_INDEX_CNT',
                  'ICPR_LINK_NAME',
                  'BEND_LOCATION',
                  'DAMPENING_THRESHOLD',
                  'ENERGY_SWITCH',
                  'FHWA_CULVERT_CODE',
                  'ICPR_GUID',
                  'DROPSTRUCTURE_ID',
                  'DROP_PIPE_CNT',
                  'DROP_PIPE_COMMENT']

        fields2 = ['ICPR_LINK_NAME',
                  'Solution',
                  'Increments',
                  'ICPR_GUID']


        #List index
        GDB_UPSTREAM_SHAPE_DESC = fields.index('UPSTREAM_SHAPE_DESC')
        GDB_UPSTREAM_INVERT_ELEVATION_MS = fields.index('UPSTREAM_INVERT_ELEVATION_MS')
        GDB_UPSTREAM_RISE_MS = fields.index('UPSTREAM_RISE_MS')
        GDB_UPSTREAM_SPAN_MS = fields.index('UPSTREAM_SPAN_MS')
        GDB_UPSTREAM_MANNINGSN_VAL = fields.index('UPSTREAM_MANNINGSN_VAL')
        GDB_UPSTREAM_INLET_DESC = fields.index('UPSTREAM_INLET_DESC')
        GDB_UPSTREAM_CROSS_SECTION = fields.index('UPSTREAM_CROSS_SECTION')
        GDB_UPSTREAM_TOPCLIP_MS = fields.index('UPSTREAM_TOPCLIP_MS')
        GDB_UPSTREAM_TOPCLIP_MANNINGSN = fields.index('UPSTREAM_TOPCLIP_MANNINGSN')
        GDB_UPSTREAM_TOPCLIP_OPTABLE = fields.index('UPSTREAM_TOPCLIP_OPTABLE')
        GDB_UPSTREAM_TOPCLIP_NODE = fields.index('UPSTREAM_TOPCLIP_NODE')
        GDB_UPSTREAM_BOTTOMCLIP_MS = fields.index('UPSTREAM_BOTTOMCLIP_MS')
        GDB_UPSTREAM_BOTTOMCLIP_MANNINGSN = fields.index('UPSTREAM_BOTTOMCLIP_MANNINGSN')
        GDB_UPSTREAM_BOTTOMCLIP_OPTABLE = fields.index('UPSTREAM_BOTTOMCLIP_OPTABLE')
        GDB_UPSTREAM_BOTTOMCLIP_NODE = fields.index('UPSTREAM_BOTTOMCLIP_NODE')
        GDB_UPSTREAM_FILLET = fields.index('UPSTREAM_FILLET')
        GDB_DOWNSTREAM_SHAPE_DESC = fields.index('DOWNSTREAM_SHAPE_DESC')
        GDB_DOWNSTREAM_INVERT_ELEVATION_MS = fields.index('DOWNSTREAM_INVERT_ELEVATION_MS')
        GDB_DOWNSTREAM_RISE_MS = fields.index('DOWNSTREAM_RISE_MS')
        GDB_DOWNSTREAM_SPAN_MS = fields.index('DOWNSTREAM_SPAN_MS')
        GDB_DOWNSTREAM_MANNINGSN_VAL = fields.index('DOWNSTREAM_MANNINGSN_VAL')
        GDB_DOWNSTREAM_INLET_DESC = fields.index('DOWNSTREAM_INLET_DESC')
        GDB_DOWNSTREAM_CROSS_SECTION = fields.index('DOWNSTREAM_CROSS_SECTION')
        GDB_DOWNSTREAM_TOPCLIP_MS = fields.index('DOWNSTREAM_TOPCLIP_MS')
        GDB_DOWNSTREAM_TOPCLIP_MANNINGSN = fields.index('DOWNSTREAM_TOPCLIP_MANNINGSN')
        GDB_DOWNSTREAM_TOPCLIP_OPTABLE = fields.index('DOWNSTREAM_TOPCLIP_OPTABLE')
        GDB_DOWNSTREAM_TOPCLIP_NODE = fields.index('DOWNSTREAM_TOPCLIP_NODE')
        GDB_DOWNSTREAM_BOTTOMCLIP_MS = fields.index('DOWNSTREAM_BOTTOMCLIP_MS')
        GDB_DOWNSTREAM_BOTTOMCLIP_MANNINGSN = fields.index('DOWNSTREAM_BOTTOMCLIP_MANNINGSN')
        GDB_DOWNSTREAM_BOTTOMCLIP_OPTABLE = fields.index('DOWNSTREAM_BOTTOMCLIP_OPTABLE')
        GDB_DOWNSTREAM_BOTTOMCLIP_NODE = fields.index('DOWNSTREAM_BOTTOMCLIP_NODE')
        GDB_DOWNSTREAM_FILLET = fields.index('DOWNSTREAM_FILLET')
        GDB_PIPE_BARREL_LENGTH_MS = fields.index('PIPE_BARREL_LENGTH_MS')
        GDB_ENTRANCE_LOSS_VAL = fields.index('ENTRANCE_LOSS_VAL')
        GDB_EXIT_LOSS_VAL = fields.index('EXIT_LOSS_VAL')
        GDB_BEND_LOSS_VAL = fields.index('BEND_LOSS_VAL')
        GDB_SUBELEMENT_INDEX_CNT = fields.index('SUBELEMENT_INDEX_CNT')
        GDB_ICPR_LINK_NAME = fields.index('ICPR_LINK_NAME')
        GDB_BEND_LOCATION = fields.index('BEND_LOCATION')
        GDB_DAMPENING_THRESHOLD = fields.index('DAMPENING_THRESHOLD')
        GDB_ENERGY_SWITCH = fields.index('ENERGY_SWITCH')
        GDB_FHWA_CULVERT_CODE = fields.index('FHWA_CULVERT_CODE')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')
        GDB_DROPSTRUCTURE_ID = fields.index('DROPSTRUCTURE_ID')
        GDB_DROP_PIPE_CNT = fields.index('DROP_PIPE_CNT')
        GDB_DROP_PIPE_COMMENT = fields.index('DROP_PIPE_COMMENT')

        #Second set of data
        GDB2_ICPR_LINK_NAME = fields2.index('ICPR_LINK_NAME')
        GDB2_Solution = fields2.index('Solution')
        GDB2_Increments = fields2.index('Increments')
        GDB2_ICPR_GUID = fields2.index('ICPR_GUID')


        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Drop ID
        Drop_ID = 0
        
        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                cursorInsert2 = arcpy.da.InsertCursor(outfc2, fields2)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_DampeningThreshold = header_row.index("DampeningThreshold")
                        CSV_Length = header_row.index("Length")
                        CSV_FHWACulvertCode = header_row.index("FHWACulvertCode")
                        CSV_EntranceLossCoef = header_row.index("EntranceLossCoef")
                        CSV_ExitLossCoef = header_row.index("ExitLossCoef")
                        CSV_BendLossCoef = header_row.index("BendLossCoef")
                        CSV_BendLocation = header_row.index("BendLocation")
                        CSV_EnergySwitch = header_row.index("EnergySwitch")
                        CSV_UsInvert = header_row.index("UsInvert")
                        CSV_UsManningsN = header_row.index("UsManningsN")
                        CSV_UsGeometry = header_row.index("UsGeometry")
                        CSV_UsMaxDepth = header_row.index("UsMaxDepth")
                        CSV_UsMaxWidth = header_row.index("UsMaxWidth")
                        CSV_UsFillet = header_row.index("UsFillet")
                        CSV_UsCrossSection = header_row.index("UsCrossSection")
                        CSV_UsBottomClip = header_row.index("UsBottomClip")
                        CSV_UsBottomClipTable = header_row.index("UsBottomClipTable")
                        CSV_UsNode_BottomClip = header_row.index("UsNode_BottomClip")
                        CSV_UsBottomClipManningsN = header_row.index("UsBottomClipManningsN")
                        CSV_UsTopClip = header_row.index("UsTopClip")
                        CSV_UsTopClipTable = header_row.index("UsTopClipTable")
                        CSV_UsNode_TopClip = header_row.index("UsNode_TopClip")
                        CSV_UsTopClipManningsN = header_row.index("UsTopClipManningsN")
                        CSV_DsInvert = header_row.index("DsInvert")
                        CSV_DsManningsN = header_row.index("DsManningsN")
                        CSV_DsGeometry = header_row.index("DsGeometry")
                        CSV_DsMaxDepth = header_row.index("DsMaxDepth")
                        CSV_DsMaxWidth = header_row.index("DsMaxWidth")
                        CSV_DsFillet = header_row.index("DsFillet")
                        CSV_DsCrossSection = header_row.index("DsCrossSection")
                        CSV_DsBottomClip = header_row.index("DsBottomClip")
                        CSV_DsBottomClipTable = header_row.index("DsBottomClipTable")
                        CSV_DsNode_BottomClip = header_row.index("DsNode_BottomClip")
                        CSV_DsBottomClipManningsN = header_row.index("DsBottomClipManningsN")
                        CSV_DsTopClip = header_row.index("DsTopClip")
                        CSV_DsTopClipTable = header_row.index("DsTopClipTable")
                        CSV_DsNode_TopClip = header_row.index("DsNode_TopClip")
                        CSV_DsTopClipManningsN = header_row.index("DsTopClipManningsN")
                        CSV_Solution = header_row.index("Solution")
                        CSV_Increments = header_row.index("Increments")
                        CSV_PipeComment = header_row.index("PipeComment")
                        CSV_PipeCount = header_row.index("PipeCount")

                    else:

                        data = iccsv.csv_parseline(line)
                        Drop_ID = Drop_ID + 1

                        #Set data formats for non-text used fields
                        data[CSV_DampeningThreshold] = float(data[CSV_DampeningThreshold])
                        data[CSV_Length] = float(data[CSV_Length])
                        data[CSV_FHWACulvertCode] = int(data[CSV_FHWACulvertCode])
                        data[CSV_EntranceLossCoef] = float(data[CSV_EntranceLossCoef])
                        data[CSV_ExitLossCoef] = float(data[CSV_ExitLossCoef])
                        data[CSV_BendLossCoef] = float(data[CSV_BendLossCoef])
                        data[CSV_BendLocation] = float(data[CSV_BendLocation])
                        data[CSV_EnergySwitch] = int(data[CSV_EnergySwitch])
                        data[CSV_UsInvert] = float(data[CSV_UsInvert])
                        data[CSV_UsManningsN] = float(data[CSV_UsManningsN])
                        data[CSV_UsGeometry] = int(data[CSV_UsGeometry])
                        data[CSV_UsMaxDepth] = float(data[CSV_UsMaxDepth])
                        data[CSV_UsMaxWidth] = float(data[CSV_UsMaxWidth])
                        data[CSV_UsFillet] = float(data[CSV_UsFillet])
                        data[CSV_UsBottomClip] = float(data[CSV_UsBottomClip])
                        data[CSV_UsBottomClipManningsN] = float(data[CSV_UsBottomClipManningsN])
                        data[CSV_UsTopClip] = float(data[CSV_UsTopClip])
                        data[CSV_UsTopClipManningsN] = float(data[CSV_UsTopClipManningsN])
                        data[CSV_DsInvert] = float(data[CSV_DsInvert])
                        data[CSV_DsManningsN] = float(data[CSV_DsManningsN])
                        data[CSV_DsGeometry] = int(data[CSV_DsGeometry])
                        data[CSV_DsMaxDepth] = float(data[CSV_DsMaxDepth])
                        data[CSV_DsMaxWidth] = float(data[CSV_DsMaxWidth])
                        data[CSV_DsFillet] = float(data[CSV_DsFillet])
                        data[CSV_DsBottomClip] = float(data[CSV_DsBottomClip])
                        data[CSV_DsBottomClipManningsN] = float(data[CSV_DsBottomClipManningsN])
                        data[CSV_DsTopClip] = float(data[CSV_DsTopClip])
                        data[CSV_DsTopClipManningsN] = float(data[CSV_DsTopClipManningsN])
                        data[CSV_Solution] = int(data[CSV_Solution])
                        data[CSV_Increments] = int(data[CSV_Increments])
                        data[CSV_PipeCount] = int(data[CSV_PipeCount])

                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
                        
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:                    
                            i = i + 1
                            if i >=1:
                                break
                        
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                ########################
                                #Determine US Span
                                ########################
                                #Cirular
                                if PipeGeomCode[data[CSV_UsGeometry]] == 0:

                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*1

                                #Horizontal Ellipse
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 1:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*1.56

                                #Vertical Ellipse
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 2:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*(1/1.56)

                                #Arch No Plate
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 3:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*(1.607)

                                #Egg Shaped
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 8:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*(2/3)

                                #Horseshoe
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 9:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*1

                                #Gothic
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 10:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*0.84

                                #Catenary
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 11:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*0.9

                                #Basket Handle
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 12:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*0.944

                                #Semi-Circular
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 13:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*1.64

                                #Semi-Elliptical
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 14:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxDepth]*12*1

                                #Con Span
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 18:
                                    row[GDB_UPSTREAM_RISE_MS] = None
                                    row[GDB_UPSTREAM_SPAN_MS] = None

                                #Arch/Rectangular/V-Notch
                                else:
                                    row[GDB_UPSTREAM_RISE_MS] = data[CSV_UsMaxDepth]*12
                                    row[GDB_UPSTREAM_SPAN_MS] = data[CSV_UsMaxWidth]*12

                                ####################
                                #Determine D/S Span
                                ####################
                                #Cirular
                                if PipeGeomCode[data[CSV_UsGeometry]] == 0:

                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*1

                                #Horizontal Ellipse
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 1:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*1.56

                                #Vertical Ellipse
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 2:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*(1/1.56)

                                #Arch No Plate
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 3:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*(1.607)

                                #Egg Shaped
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 8:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*(2/3)

                                #Horseshoe
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 9:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*1

                                #Gothic
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 10:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*0.84

                                #Catenary
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 11:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*0.9

                                #Basket Handle
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 12:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*0.944

                                #Semi-Circular
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 13:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*1.64

                                #Semi-Elliptical
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 14:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxDepth]*12*1

                                #Con Span
                                elif PipeGeomCode[data[CSV_UsGeometry]] == 18:
                                    row[GDB_DOWNSTREAM_RISE_MS] = None
                                    row[GDB_DOWNSTREAM_SPAN_MS] = None

                                #Arch/Rectangular/V-Notch
                                else:
                                    row[GDB_DOWNSTREAM_RISE_MS] = data[CSV_DsMaxDepth]*12
                                    row[GDB_DOWNSTREAM_SPAN_MS] = data[CSV_DsMaxWidth]*12

                                #################################
                                #Specify Inlet Edge Description
                                #################################
                                #Critical Depth
                                if data[CSV_FHWACulvertCode] == 0:
                                    row[GDB_UPSTREAM_INLET_DESC] = None

                                #FHWA Used
                                else:
                                    row[GDB_UPSTREAM_INLET_DESC] = data[CSV_FHWACulvertCode]-1

                                #################################
                                #Assign Link name
                                #################################
                                try:
                                    row[GDB_ICPR_LINK_NAME] = LUpDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_ICPR_LINK_NAME] = LAddDict[data[CSV_ParentID]][1]

                                ##################################
                                #Process data for direct transfer
                                ##################################
                                row[GDB_UPSTREAM_SHAPE_DESC] = PipeGeomCode[data[CSV_UsGeometry]]
                                row[GDB_UPSTREAM_MANNINGSN_VAL] = data[CSV_UsManningsN]
                                row[GDB_UPSTREAM_INVERT_ELEVATION_MS] = data[CSV_UsInvert]
                                row[GDB_UPSTREAM_CROSS_SECTION] = data[CSV_UsCrossSection]
                                row[GDB_UPSTREAM_TOPCLIP_MS] = data[CSV_UsTopClip]*12
                                row[GDB_UPSTREAM_TOPCLIP_MANNINGSN] = data[CSV_UsTopClipManningsN]
                                row[GDB_UPSTREAM_TOPCLIP_OPTABLE] = data[CSV_UsTopClipTable]
                                row[GDB_UPSTREAM_TOPCLIP_NODE] = data[CSV_UsNode_TopClip]
                                row[GDB_UPSTREAM_BOTTOMCLIP_MS] = data[CSV_UsBottomClip]*12
                                row[GDB_UPSTREAM_BOTTOMCLIP_MANNINGSN] = data[CSV_UsBottomClipManningsN]
                                row[GDB_UPSTREAM_BOTTOMCLIP_OPTABLE] = data[CSV_UsBottomClipTable]
                                row[GDB_UPSTREAM_BOTTOMCLIP_NODE] = data[CSV_UsNode_BottomClip]
                                row[GDB_UPSTREAM_FILLET] = data[CSV_UsFillet]
                                row[GDB_DOWNSTREAM_SHAPE_DESC] = PipeGeomCode[data[CSV_DsGeometry]]
                                row[GDB_DOWNSTREAM_INVERT_ELEVATION_MS] = data[CSV_DsInvert]
                                row[GDB_DOWNSTREAM_MANNINGSN_VAL] = data[CSV_DsManningsN]
                                row[GDB_DOWNSTREAM_CROSS_SECTION] = data[CSV_DsCrossSection]
                                row[GDB_DOWNSTREAM_TOPCLIP_MS] = data[CSV_DsTopClip]*12
                                row[GDB_DOWNSTREAM_TOPCLIP_MANNINGSN] = data[CSV_DsTopClipManningsN]
                                row[GDB_DOWNSTREAM_TOPCLIP_OPTABLE] = data[CSV_DsTopClipTable]
                                row[GDB_DOWNSTREAM_TOPCLIP_NODE] = data[CSV_DsNode_TopClip]
                                row[GDB_DOWNSTREAM_BOTTOMCLIP_MS] = data[CSV_DsBottomClip] * 12
                                row[GDB_DOWNSTREAM_BOTTOMCLIP_MANNINGSN]=data[CSV_DsBottomClipManningsN]
                                row[GDB_DOWNSTREAM_BOTTOMCLIP_OPTABLE]=data[CSV_DsBottomClipTable]
                                row[GDB_DOWNSTREAM_BOTTOMCLIP_NODE] = data[CSV_DsNode_BottomClip]
                                row[GDB_DOWNSTREAM_FILLET] = data[CSV_UsFillet]
                                row[GDB_PIPE_BARREL_LENGTH_MS] = data[CSV_Length]
                                row[GDB_ENTRANCE_LOSS_VAL] = data[CSV_EntranceLossCoef]
                                row[GDB_EXIT_LOSS_VAL] = data[CSV_ExitLossCoef]
                                row[GDB_BEND_LOSS_VAL] = data[CSV_BendLossCoef]
                                row[GDB_SUBELEMENT_INDEX_CNT] = 1
                                row[GDB_BEND_LOCATION] = data[CSV_BendLocation]
                                row[GDB_DAMPENING_THRESHOLD] = data[CSV_DampeningThreshold]
                                row[GDB_ENERGY_SWITCH] = data[CSV_EnergySwitch]
                                row[GDB_FHWA_CULVERT_CODE] = data[CSV_FHWACulvertCode]
                                row[GDB_ICPR_GUID] = data[CSV_ID]
                                row[GDB_DROP_PIPE_CNT] = data[CSV_PipeCount]
                                row[GDB_DROP_PIPE_COMMENT]=data[CSV_PipeComment]
                                row[GDB_DROPSTRUCTURE_ID] = Drop_ID

                                #update row
                                cursorUpdate.updateRow(row)

                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID], Drop_ID, row[GDB_ICPR_LINK_NAME]]
                                
                            del cursorUpdate

                            #Update drop structure table
                            cursorUpdate = arcpy.da.UpdateCursor(outfc2, fields2,where_clause = expression)                    

                            for row in cursorUpdate:

                                #################################
                                #Assign Link name
                                #################################
                                try:
                                    row[GDB2_ICPR_LINK_NAME] = LUpDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB2_ICPR_LINK_NAME] = LAddDict[data[CSV_ParentID]][1]

                                row[GDB2_Solution] = data[CSV_Solution]
                                row[GDB2_Increments] = data[CSV_Increments]
                                row[GDB2_ICPR_GUID] = data[CSV_ID]

                                #update row
                                cursorUpdate.updateRow(row)
                            del cursorUpdate


                        ###############
                        #Add new data
                        ###############
                        else:
                            ###################
                            #Determine US Span
                            ###################
                            #Cirular
                            if PipeGeomCode[data[CSV_UsGeometry]] == 0:

                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*1

                            #Horizontal Ellipse
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 1:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*1.56

                            #Vertical Ellipse
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 2:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*(1/1.56)

                            #Arch No Plate
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 3:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*(1.607)

                            #Egg Shaped
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 8:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*(2/3)

                            #Horseshoe
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 9:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*1

                            #Gothic
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 10:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*0.84

                            #Catenary
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 11:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*0.9

                            #Basket Handle
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 12:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*0.944

                            #Semi-Circular
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 13:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*1.64

                            #Semi-Elliptical
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 14:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxDepth]*12*1

                            #Con Span
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 18:
                                UPSTREAM_RISE_MS = None
                                UPSTREAM_SPAN_MS = None

                            #Arch/Rectangular/V-Notch
                            else:
                                UPSTREAM_RISE_MS = data[CSV_UsMaxDepth]*12
                                UPSTREAM_SPAN_MS = data[CSV_UsMaxWidth]*12

                            ###################
                            #Determine D/S Span
                            ###################
                            #Cirular
                            if PipeGeomCode[data[CSV_UsGeometry]] == 0:

                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*1

                            #Horizontal Ellipse
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 1:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*1.56

                            #Vertical Ellipse
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 2:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*(1/1.56)

                            #Arch No Plate
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 3:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*(1.607)

                            #Egg Shaped
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 8:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*(2/3)

                            #Horseshoe
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 9:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*1

                            #Gothic
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 10:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*0.84

                            #Catenary
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 11:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*0.9

                            #Basket Handle
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 12:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*0.944

                            #Semi-Circular
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 13:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*1.64

                            #Semi-Elliptical
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 14:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxDepth]*12*1

                            #Con Span
                            elif PipeGeomCode[data[CSV_UsGeometry]] == 18:
                                DOWNSTREAM_RISE_MS = None
                                DOWNSTREAM_SPAN_MS = None

                            #Arch/Rectangular/V-Notch
                            else:
                                DOWNSTREAM_RISE_MS = data[CSV_DsMaxDepth]*12
                                DOWNSTREAM_SPAN_MS = data[CSV_DsMaxWidth]*12

                            #################################
                            #Specify Inlet Edge Description
                            #################################
                            #Critical Depth
                            if data[CSV_FHWACulvertCode] == 0:
                                UPSTREAM_INLET_DESC = None
                                DOWNSTREAM_INLET_DESC = None

                            #FHWA Used
                            else:
                                UPSTREAM_INLET_DESC = data[CSV_FHWACulvertCode]-1
                                DOWNSTREAM_INLET_DESC = None

                            #################################
                            #Assign Link name
                            #################################
                            try:
                                ICPR_LINK_NAME = LAddDict[data[CSV_ParentID]][1]
                            except:
                                ICPR_LINK_NAME = LUpDict[data[CSV_ParentID]][1]


                            ##################################
                            #Process data for direct transfer
                            ##################################
                            UPSTREAM_SHAPE_DESC = PipeGeomCode[data[CSV_UsGeometry]]
                            UPSTREAM_MANNINGSN_VAL = data[CSV_UsManningsN]
                            UPSTREAM_INVERT_ELEVATION_MS = data[CSV_UsInvert]
                            UPSTREAM_CROSS_SECTION = data[CSV_UsCrossSection]
                            UPSTREAM_TOPCLIP_MS = data[CSV_UsTopClip]*12
                            UPSTREAM_TOPCLIP_MANNINGSN = data[CSV_UsTopClipManningsN]
                            UPSTREAM_TOPCLIP_OPTABLE = data[CSV_UsTopClipTable]
                            UPSTREAM_TOPCLIP_NODE = data[CSV_UsNode_TopClip]
                            UPSTREAM_BOTTOMCLIP_MS = data[CSV_UsBottomClip]*12
                            UPSTREAM_BOTTOMCLIP_MANNINGSN = data[CSV_UsBottomClipManningsN]
                            UPSTREAM_BOTTOMCLIP_OPTABLE = data[CSV_UsBottomClipTable]
                            UPSTREAM_BOTTOMCLIP_NODE = data[CSV_UsNode_BottomClip]
                            UPSTREAM_FILLET = data[CSV_UsFillet]
                            DOWNSTREAM_SHAPE_DESC = PipeGeomCode[data[CSV_DsGeometry]]
                            DOWNSTREAM_INVERT_ELEVATION_MS = data[CSV_DsInvert]
                            DOWNSTREAM_MANNINGSN_VAL = data[CSV_DsManningsN]
                            DOWNSTREAM_CROSS_SECTION = data[CSV_DsCrossSection]
                            DOWNSTREAM_TOPCLIP_MS = data[CSV_DsTopClip]*12
                            DOWNSTREAM_TOPCLIP_MANNINGSN = data[CSV_DsTopClipManningsN]
                            DOWNSTREAM_TOPCLIP_OPTABLE = data[CSV_DsTopClipTable]
                            DOWNSTREAM_TOPCLIP_NODE = data[CSV_DsNode_TopClip]
                            DOWNSTREAM_BOTTOMCLIP_MS = data[CSV_DsBottomClip] * 12
                            DOWNSTREAM_BOTTOMCLIP_MANNINGSN=data[CSV_DsBottomClipManningsN]
                            DOWNSTREAM_BOTTOMCLIP_OPTABLE=data[CSV_DsBottomClipTable]
                            DOWNSTREAM_BOTTOMCLIP_NODE = data[CSV_DsNode_BottomClip]
                            DOWNSTREAM_FILLET = data[CSV_UsFillet]
                            PIPE_BARREL_LENGTH_MS = data[CSV_Length]
                            ENTRANCE_LOSS_VAL = data[CSV_EntranceLossCoef]
                            EXIT_LOSS_VAL = data[CSV_ExitLossCoef]
                            BEND_LOSS_VAL = data[CSV_BendLossCoef]
                            SUBELEMENT_INDEX_CNT = 1
                            BEND_LOCATION = data[CSV_BendLocation]
                            DAMPENING_THRESHOLD = data[CSV_DampeningThreshold]
                            ENERGY_SWITCH = data[CSV_EnergySwitch]
                            FHWA_CULVERT_CODE = data[CSV_FHWACulvertCode]
                            ICPR_GUID = data[CSV_ID]
                            DROP_PIPE_CNT = data[CSV_PipeCount]
                            DROP_PIPE_COMMENT = data[CSV_PipeComment]
                            Solution = data[CSV_Solution]
                            Increments = data[CSV_Increments]

                            #New Record Data
                            In_Data = (UPSTREAM_SHAPE_DESC,
                                       UPSTREAM_INVERT_ELEVATION_MS,
                                       UPSTREAM_RISE_MS,
                                       UPSTREAM_SPAN_MS,
                                       UPSTREAM_MANNINGSN_VAL,
                                       UPSTREAM_INLET_DESC,
                                       UPSTREAM_CROSS_SECTION,
                                       UPSTREAM_TOPCLIP_MS,
                                       UPSTREAM_TOPCLIP_MANNINGSN,
                                       UPSTREAM_TOPCLIP_OPTABLE,
                                       UPSTREAM_TOPCLIP_NODE,
                                       UPSTREAM_BOTTOMCLIP_MS,
                                       UPSTREAM_BOTTOMCLIP_MANNINGSN,
                                       UPSTREAM_BOTTOMCLIP_OPTABLE,
                                       UPSTREAM_BOTTOMCLIP_NODE,
                                       UPSTREAM_FILLET,
                                       DOWNSTREAM_SHAPE_DESC,
                                       DOWNSTREAM_INVERT_ELEVATION_MS,
                                       DOWNSTREAM_RISE_MS,
                                       DOWNSTREAM_SPAN_MS,
                                       DOWNSTREAM_MANNINGSN_VAL,
                                       DOWNSTREAM_INLET_DESC,
                                       DOWNSTREAM_CROSS_SECTION,
                                       DOWNSTREAM_TOPCLIP_MS,
                                       DOWNSTREAM_TOPCLIP_MANNINGSN,
                                       DOWNSTREAM_TOPCLIP_OPTABLE,
                                       DOWNSTREAM_TOPCLIP_NODE,
                                       DOWNSTREAM_BOTTOMCLIP_MS,
                                       DOWNSTREAM_BOTTOMCLIP_MANNINGSN,
                                       DOWNSTREAM_BOTTOMCLIP_OPTABLE,
                                       DOWNSTREAM_BOTTOMCLIP_NODE,
                                       DOWNSTREAM_FILLET,
                                       PIPE_BARREL_LENGTH_MS,
                                       ENTRANCE_LOSS_VAL,
                                       EXIT_LOSS_VAL,
                                       BEND_LOSS_VAL,
                                       SUBELEMENT_INDEX_CNT,
                                       ICPR_LINK_NAME,
                                       BEND_LOCATION,
                                       DAMPENING_THRESHOLD,
                                       ENERGY_SWITCH,
                                       FHWA_CULVERT_CODE,
                                       ICPR_GUID,
                                       Drop_ID,
                                       DROP_PIPE_CNT,
                                       DROP_PIPE_COMMENT)

                            #Insert new record
                            cursorInsert.insertRow(In_Data)
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID], Drop_ID, ICPR_LINK_NAME]

                            #Add new records to the Drop Structure Table
                            In_Data = (ICPR_LINK_NAME,
                                       Solution,
                                       Increments,
                                       ICPR_GUID)

                            cursorInsert2.insertRow(In_Data)
                del cursorInsert2
                del cursorInsert

    except:
        arcpy.GetMessages()

    #Cycle through all data to delete values if required
    try:
        if Merge == False:

            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)

            for row in cursorUpdate:

                if row[GDB_ICPR_GUID] not in AddDict:
                    if row[GDB_ICPR_GUID] not in UpDict:
                        if row[GDB_ICPR_LINK_NAME] is not None:                            
                            if len(row[GDB_ICPR_LINK_NAME])>0:
                                if row[GDB_DROPSTRUCTURE_ID] is not None:                                    
                                    if row[GDB_DROPSTRUCTURE_ID]>=0:
                                        cursorUpdate.deleteRow()
            del cursorUpdate
    except:
        
        arcpy.GetMessages()


##########################################################################################################################
#Update attribute table data and no geometry data - Drop Weirs
##########################################################################################################################
    try:

        #Output
        outfc = "WEIR"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_DropStructure_Weir.csv"


        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Fields for update of existing elements/features
        fields = ['WEIR_SHAPE_DESC',
                  'WEIR_TYPE_DESC',
                  'WEIR_SPAN_MS',
                  'WEIR_RISE_MS',
                  'WEIR_INVERT_ELEVATION_MS',
                  'CONTROL_ELEVATION_MS',
                  'WEIR_BOTTOMCLIP_MS',
                  'BOTTOMCLIP_OPTABLE',
                  'BOTTOMCLIP_NODE',
                  'WEIR_TOPCLIP_MS',
                  'TOPCLIP_OPTABLE',
                  'TOPCLIP_NODE',
                  'WEIR_DISCHARGE_COEF_VAL',
                  'WEIRCOEF_OPTABLE',
                  'ORIFICE_DISCHARGE_COEF_VAL',
                  'ORIFICECOEF_OPTABLE',
                  'DROPSTRUCTURE_ID',
                  'SECTION_NAME',
                  'LEFTSIDE_SLOPE_VAL',
                  'RIGHTSIDE_SLOPE_VAL',
                  'WEIR_BOTTOM_WIDTH_MS',
                  'WEIR_ORIENTATION_DESC',
                  'SUBELEMENT_INDEX_CNT',
                  'ICPR_LINK_NAME',
                  'DAMPENING_THRESHOLD',
                  'EXTRAPOLATION_METHOD',
                  'FILLET',
                  'DROP_WEIR_CNT',
                  'DROP_WEIR_NAME',
                  'DROP_WEIR_COMMENT',
                  'Drop_Weir_Flow',
                  'ICPR_GUID']
        
        #List index
        GDB_WEIR_SHAPE_DESC = fields.index('WEIR_SHAPE_DESC')
        GDB_WEIR_TYPE_DESC = fields.index('WEIR_TYPE_DESC')
        GDB_WEIR_SPAN_MS = fields.index('WEIR_SPAN_MS')
        GDB_WEIR_RISE_MS = fields.index('WEIR_RISE_MS')
        GDB_WEIR_INVERT_ELEVATION_MS = fields.index('WEIR_INVERT_ELEVATION_MS')
        GDB_CONTROL_ELEVATION_MS = fields.index('CONTROL_ELEVATION_MS')
        GDB_WEIR_BOTTOMCLIP_MS = fields.index('WEIR_BOTTOMCLIP_MS')
        GDB_BOTTOMCLIP_OPTABLE = fields.index('BOTTOMCLIP_OPTABLE')
        GDB_BOTTOMCLIP_NODE = fields.index('BOTTOMCLIP_NODE')
        GDB_WEIR_TOPCLIP_MS = fields.index('WEIR_TOPCLIP_MS')
        GDB_TOPCLIP_OPTABLE = fields.index('TOPCLIP_OPTABLE')
        GDB_TOPCLIP_NODE = fields.index('TOPCLIP_NODE')
        GDB_WEIR_DISCHARGE_COEF_VAL = fields.index('WEIR_DISCHARGE_COEF_VAL')
        GDB_WEIRCOEF_OPTABLE = fields.index('WEIRCOEF_OPTABLE')
        GDB_ORIFICE_DISCHARGE_COEF_VAL = fields.index('ORIFICE_DISCHARGE_COEF_VAL')
        GDB_ORIFICECOEF_OPTABLE = fields.index('ORIFICECOEF_OPTABLE')
        GDB_DROPSTRUCTURE_ID = fields.index('DROPSTRUCTURE_ID')
        GDB_SECTION_NAME = fields.index('SECTION_NAME')
        GDB_LEFTSIDE_SLOPE_VAL = fields.index('LEFTSIDE_SLOPE_VAL')
        GDB_RIGHTSIDE_SLOPE_VAL = fields.index('RIGHTSIDE_SLOPE_VAL')
        GDB_WEIR_BOTTOM_WIDTH_MS = fields.index('WEIR_BOTTOM_WIDTH_MS')
        GDB_WEIR_ORIENTATION_DESC = fields.index('WEIR_ORIENTATION_DESC')
        GDB_SUBELEMENT_INDEX_CNT = fields.index('SUBELEMENT_INDEX_CNT')
        GDB_ICPR_LINK_NAME = fields.index('ICPR_LINK_NAME')
        GDB_DAMPENING_THRESHOLD = fields.index('DAMPENING_THRESHOLD')
        GDB_EXTRAPOLATION_METHOD = fields.index('EXTRAPOLATION_METHOD')
        GDB_FILLET = fields.index('FILLET')
        GDB_DROP_WEIR_CNT = fields.index('DROP_WEIR_CNT')
        GDB_DROP_WEIR_NAME = fields.index('DROP_WEIR_NAME')
        GDB_DROP_WEIR_COMMENT = fields.index('DROP_WEIR_COMMENT')
        GDB_Drop_Weir_Flow = fields.index('Drop_Weir_Flow')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        DW_UpDict = {}
        DW_AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_Name = header_row.index("Name")
                        CSV_WeirCount = header_row.index("WeirCount")
                        CSV_WeirFlowDirection = header_row.index("WeirFlowDirection")
                        CSV_DampeningThreshold = header_row.index("DampeningThreshold")
                        CSV_WeirType = header_row.index("WeirType")
                        CSV_Geometry = header_row.index("Geometry")
                        CSV_Invert = header_row.index("Invert")
                        CSV_ControlElevation = header_row.index("ControlElevation")
                        CSV_CrossSection = header_row.index("CrossSection")
                        CSV_ExtrapolationMethod = header_row.index("ExtrapolationMethod")
                        CSV_MaxDepth = header_row.index("MaxDepth")
                        CSV_MaxWidth = header_row.index("MaxWidth")
                        CSV_Fillet = header_row.index("Fillet")
                        CSV_BottomWidth = header_row.index("BottomWidth")
                        CSV_LeftSideSlope = header_row.index("LeftSideSlope")
                        CSV_RightSideSlope = header_row.index("RightSideSlope")
                        CSV_BottomClip = header_row.index("BottomClip")
                        CSV_TopClip = header_row.index("TopClip")
                        CSV_WeirDischargeCoef = header_row.index("WeirDischargeCoef")
                        CSV_OrificeDischargeCoef = header_row.index("OrificeDischargeCoef")
                        CSV_BottomClipTable = header_row.index("BottomClipTable")
                        CSV_TopClipTable = header_row.index("TopClipTable")
                        CSV_WeirDischargeCoefTable = header_row.index("WeirDischargeCoefTable")
                        CSV_OrificeDischargeCoefTable = header_row.index("OrificeDischargeCoefTable")
                        CSV_Node_BottomClip = header_row.index("Node_BottomClip")
                        CSV_Node_TopClip = header_row.index("Node_TopClip")
                        CSV_Comment = header_row.index("Comment")

                    else:

                        data = iccsv.csv_parseline(line)

                        #Set data formats for non-text used fields
                        data[CSV_WeirCount] = int(data[CSV_WeirCount])
                        data[CSV_WeirFlowDirection] = int(data[CSV_WeirFlowDirection])
                        data[CSV_DampeningThreshold] = float(data[CSV_DampeningThreshold])
                        data[CSV_WeirType] = int(data[CSV_WeirType])
                        data[CSV_Geometry] = int(data[CSV_Geometry])
                        data[CSV_Invert] = float(data[CSV_Invert])
                        data[CSV_ControlElevation] = float(data[CSV_ControlElevation])
                        data[CSV_ExtrapolationMethod] = int(data[CSV_ExtrapolationMethod])
                        data[CSV_MaxDepth] = float(data[CSV_MaxDepth])
                        data[CSV_MaxWidth] = float(data[CSV_MaxWidth])
                        data[CSV_Fillet] = float(data[CSV_Fillet])
                        data[CSV_BottomWidth] = float(data[CSV_BottomWidth])
                        data[CSV_LeftSideSlope] = float(data[CSV_LeftSideSlope])
                        data[CSV_RightSideSlope] = float(data[CSV_RightSideSlope])
                        data[CSV_BottomClip] = float(data[CSV_BottomClip])
                        data[CSV_TopClip] = float(data[CSV_TopClip])
                        data[CSV_WeirDischargeCoef] = float(data[CSV_WeirDischargeCoef])
                        data[CSV_OrificeDischargeCoef] = float(data[CSV_OrificeDischargeCoef])
                        
                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)
                        
                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:                    
                            i = i + 1
                            if i >=1:
                                break
                        
                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                ########################
                                #Determine Span
                                ########################
                                #Cirular
                                if WeirGeomDict[data[CSV_Geometry]] == 0:

                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1

                                #Horizontal Ellipse
                                elif WeirGeomDict[data[CSV_Geometry]] == 1:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1.56

                                #Vertical Ellipse
                                elif WeirGeomDict[data[CSV_Geometry]] == 2:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*(1/1.56)                            

                                #Egg Shaped
                                elif WeirGeomDict[data[CSV_Geometry]] == 8:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*(2/3)

                                #Horseshoe
                                elif WeirGeomDict[data[CSV_Geometry]] == 9:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1

                                #Gothic
                                elif WeirGeomDict[data[CSV_Geometry]] == 10:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*0.84

                                #Catenary
                                elif WeirGeomDict[data[CSV_Geometry]] == 11:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*0.9

                                #Basket Handle
                                elif WeirGeomDict[data[CSV_Geometry]] == 12:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*0.944

                                #Semi-Circular
                                elif WeirGeomDict[data[CSV_Geometry]] == 13:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1.64

                                #Semi-Elliptical
                                elif WeirGeomDict[data[CSV_Geometry]] == 14:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxDepth]*12*1

                                #Con Span
                                elif WeirGeomDict[data[CSV_Geometry]] == 18:
                                    row[GDB_WEIR_RISE_MS] = None
                                    row[GDB_WEIR_SPAN_MS] = None

                                #Arch/Rectangular/V-Notch/Parabolic
                                else:
                                    row[GDB_WEIR_RISE_MS] = data[CSV_MaxDepth]*12
                                    row[GDB_WEIR_SPAN_MS] = data[CSV_MaxWidth]*12


                                #################################
                                #Assign Link name
                                #################################
                                try:
                                    row[GDB_ICPR_LINK_NAME] = UpDict[data[CSV_ParentID]][2]
                                except:
                                    row[GDB_ICPR_LINK_NAME] = AddDict[data[CSV_ParentID]][2]

                                ##################################
                                #Process data for direct transfer
                                ##################################

                                row[GDB_WEIR_SHAPE_DESC] = WeirGeomDict[data[CSV_Geometry]]
                                row[GDB_WEIR_TYPE_DESC] = WeirOrienDict[data[CSV_WeirType]][1]
                                row[GDB_WEIR_INVERT_ELEVATION_MS] = data[CSV_Invert]
                                row[GDB_CONTROL_ELEVATION_MS] = data[CSV_ControlElevation]
                                row[GDB_WEIR_BOTTOMCLIP_MS] = data[CSV_BottomClip]*12
                                row[GDB_BOTTOMCLIP_OPTABLE] = data[CSV_BottomClipTable]
                                row[GDB_BOTTOMCLIP_NODE] = data[CSV_Node_BottomClip]
                                row[GDB_WEIR_TOPCLIP_MS] = data[CSV_TopClip]*12
                                row[GDB_TOPCLIP_OPTABLE] = data[CSV_TopClipTable]
                                row[GDB_TOPCLIP_NODE] = data[CSV_Node_TopClip]
                                row[GDB_WEIR_DISCHARGE_COEF_VAL] = data[CSV_WeirDischargeCoef]
                                row[GDB_WEIRCOEF_OPTABLE] = data[CSV_WeirDischargeCoefTable]
                                row[GDB_ORIFICE_DISCHARGE_COEF_VAL] = data[CSV_OrificeDischargeCoef]
                                row[GDB_ORIFICECOEF_OPTABLE] = data[CSV_OrificeDischargeCoefTable]
                                row[GDB_SECTION_NAME] = data[CSV_CrossSection]
                                row[GDB_LEFTSIDE_SLOPE_VAL] = data[CSV_LeftSideSlope]
                                row[GDB_RIGHTSIDE_SLOPE_VAL] = data[CSV_RightSideSlope]
                                row[GDB_WEIR_BOTTOM_WIDTH_MS] = data[CSV_BottomWidth]
                                row[GDB_WEIR_ORIENTATION_DESC] = WeirOrienDict[data[CSV_WeirType]][0]
                                row[GDB_SUBELEMENT_INDEX_CNT] = 1
                                row[GDB_DAMPENING_THRESHOLD] = data[CSV_DampeningThreshold]
                                row[GDB_EXTRAPOLATION_METHOD] = data[CSV_ExtrapolationMethod]
                                row[GDB_FILLET] = data[CSV_Fillet]
                                row[GDB_DROP_WEIR_CNT] = data[CSV_WeirCount]
                                row[GDB_DROP_WEIR_NAME] = data[CSV_Name]
                                row[GDB_DROP_WEIR_COMMENT] = data[CSV_Comment]
                                row[GDB_Drop_Weir_Flow] = data[CSV_WeirFlowDirection]
                                row[GDB_ICPR_GUID] = data[CSV_ID]

                                #Populate drop link name
                                try:                                
                                    row[GDB_DROPSTRUCTURE_ID] = AddDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_DROPSTRUCTURE_ID] = UpDict[data[CSV_ParentID]][1]

                                #update row
                                cursorUpdate.updateRow(row)

                                #Updated Features / No geometry data
                                DW_UpDict[data[CSV_ID]]=[data[CSV_ID]]
                            del cursorUpdate                       

                        ###############
                        #Add new data
                        ###############
                        else:
                        
                            ########################
                            #Determine Span
                            ########################
                            #Cirular
                            if WeirGeomDict[data[CSV_Geometry]] == 0:

                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1

                            #Horizontal Ellipse
                            elif WeirGeomDict[data[CSV_Geometry]] == 1:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1.56

                            #Vertical Ellipse
                            elif WeirGeomDict[data[CSV_Geometry]] == 2:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*(1/1.56)                            

                            #Egg Shaped
                            elif WeirGeomDict[data[CSV_Geometry]] == 8:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*(2/3)

                            #Horseshoe
                            elif WeirGeomDict[data[CSV_Geometry]] == 9:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1

                            #Gothic
                            elif WeirGeomDict[data[CSV_Geometry]] == 10:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*0.84

                            #Catenary
                            elif WeirGeomDict[data[CSV_Geometry]] == 11:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*0.9

                            #Basket Handle
                            elif WeirGeomDict[data[CSV_Geometry]] == 12:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*0.944

                            #Semi-Circular
                            elif WeirGeomDict[data[CSV_Geometry]] == 13:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1.64

                            #Semi-Elliptical
                            elif WeirGeomDict[data[CSV_Geometry]] == 14:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxDepth]*12*1

                            #Con Span
                            elif WeirGeomDict[data[CSV_Geometry]] == 18:
                                WEIR_RISE_MS = None
                                WEIR_SPAN_MS = None

                            #Arch/Rectangular/V-Notch/Parabolic
                            else:
                                WEIR_RISE_MS = data[CSV_MaxDepth]*12
                                WEIR_SPAN_MS = data[CSV_MaxWidth]*12


                            #################################
                            #Assign Link name
                            #################################
                            try:
                                ICPR_LINK_NAME = UpDict[data[CSV_ParentID]][2]
                            except:
                                ICPR_LINK_NAME = AddDict[data[CSV_ParentID]][2]

                            ##################################
                            #Process data for direct transfer
                            ##################################

                            WEIR_SHAPE_DESC = WeirGeomDict[data[CSV_Geometry]]
                            WEIR_TYPE_DESC = WeirOrienDict[data[CSV_WeirType]][1]
                            WEIR_INVERT_ELEVATION_MS = data[CSV_Invert]
                            CONTROL_ELEVATION_MS = data[CSV_ControlElevation]
                            WEIR_BOTTOMCLIP_MS = data[CSV_BottomClip]*12
                            BOTTOMCLIP_OPTABLE = data[CSV_BottomClipTable]
                            BOTTOMCLIP_NODE = data[CSV_Node_BottomClip]
                            WEIR_TOPCLIP_MS = data[CSV_TopClip]*12
                            TOPCLIP_OPTABLE = data[CSV_TopClipTable]
                            TOPCLIP_NODE = data[CSV_Node_TopClip]
                            WEIR_DISCHARGE_COEF_VAL = data[CSV_WeirDischargeCoef]
                            WEIRCOEF_OPTABLE = data[CSV_WeirDischargeCoefTable]
                            ORIFICE_DISCHARGE_COEF_VAL = data[CSV_OrificeDischargeCoef]
                            ORIFICECOEF_OPTABLE = data[CSV_OrificeDischargeCoefTable]
                            SECTION_NAME = data[CSV_CrossSection]
                            LEFTSIDE_SLOPE_VAL = data[CSV_LeftSideSlope]
                            RIGHTSIDE_SLOPE_VAL = data[CSV_RightSideSlope]
                            WEIR_BOTTOM_WIDTH_MS = data[CSV_BottomWidth]
                            WEIR_ORIENTATION_DESC = WeirOrienDict[data[CSV_WeirType]][0]
                            SUBELEMENT_INDEX_CNT = 1
                            DAMPENING_THRESHOLD = data[CSV_DampeningThreshold]
                            EXTRAPOLATION_METHOD = data[CSV_ExtrapolationMethod]
                            FILLET = data[CSV_Fillet]
                            DROP_WEIR_CNT = data[CSV_WeirCount]
                            DROP_WEIR_NAME = data[CSV_Name]
                            DROP_WEIR_COMMENT = data[CSV_Comment]
                            Drop_Weir_Flow = data[CSV_WeirFlowDirection]
                            ICPR_GUID = data[CSV_ID]

                            #Populate drop link name
                            try:                                
                                DROPSTRUCTURE_ID = AddDict[data[CSV_ParentID]][1]
                            except:
                                DROPSTRUCTURE_ID = UpDict[data[CSV_ParentID]][1]

                            #New Record Data
                            In_Data = [WEIR_SHAPE_DESC,
                                       WEIR_TYPE_DESC,
                                       WEIR_SPAN_MS,
                                       WEIR_RISE_MS,
                                       WEIR_INVERT_ELEVATION_MS,
                                       CONTROL_ELEVATION_MS,
                                       WEIR_BOTTOMCLIP_MS,
                                       BOTTOMCLIP_OPTABLE,
                                       BOTTOMCLIP_NODE,
                                       WEIR_TOPCLIP_MS,
                                       TOPCLIP_OPTABLE,
                                       TOPCLIP_NODE,
                                       WEIR_DISCHARGE_COEF_VAL,
                                       WEIRCOEF_OPTABLE,
                                       ORIFICE_DISCHARGE_COEF_VAL,
                                       ORIFICECOEF_OPTABLE,
                                       DROPSTRUCTURE_ID,
                                       SECTION_NAME,
                                       LEFTSIDE_SLOPE_VAL,
                                       RIGHTSIDE_SLOPE_VAL,
                                       WEIR_BOTTOM_WIDTH_MS,
                                       WEIR_ORIENTATION_DESC,
                                       SUBELEMENT_INDEX_CNT,
                                       ICPR_LINK_NAME,
                                       DAMPENING_THRESHOLD,
                                       EXTRAPOLATION_METHOD,
                                       FILLET,
                                       DROP_WEIR_CNT,
                                       DROP_WEIR_NAME,
                                       DROP_WEIR_COMMENT,
                                       Drop_Weir_Flow,
                                       ICPR_GUID]

                            #Insert new record
                            cursorInsert.insertRow(In_Data)                        

                            #Added features/data
                            DW_AddDict[data[CSV_ID]]=[data[CSV_ID]]
                            
                del cursorInsert

    except:
        arcpy.GetMessages()

    #Cycle through all data to delete values if required
    try:
        if Merge == False:

            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)

            for row in cursorUpdate:

                if row[GDB_ICPR_GUID] not in DW_AddDict:
                    if row[GDB_ICPR_GUID] not in DW_UpDict:
                        if row[GDB_ICPR_LINK_NAME] is not None:
                            if len(row[GDB_ICPR_LINK_NAME])>0:
                                if row[GDB_DROPSTRUCTURE_ID] is not None:
                                    if row[GDB_DROPSTRUCTURE_ID]>= 0:
                                        cursorUpdate.deleteRow()

            del cursorUpdate

    except:
        arcpy.GetMessages()

    #Cycle through all data to delete values if required from drop structure table
    try:
        if Merge == False:

            cursorUpdate = arcpy.da.UpdateCursor(outfc2, fields2)

            for row in cursorUpdate:
                if row[GDB2_ICPR_GUID] not in AddDict:
                    if row[GDB2_ICPR_GUID] not in UpDict:
                        if row[GDB2_ICPR_LINK_NAME] is not None:
                            if len(row[GDB2_ICPR_LINK_NAME])>0:
                                cursorUpdate.deleteRow()
                        if row[GDB2_ICPR_LINK_NAME] is None:
                            cursorUpdate.deleteRow()
                            
            del cursorUpdate
    except:
        arcpy.GetMessages()

