#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Imports/Merges data from CSV to GWIS2.1 geodatabase

import arcpy
import iccsv

##########################################################################################################################
#Breach module
##########################################################################################################################
def UpdateBreach(infc1, Merge, Filestem, LAddDict, LUpDict):

##########################################################################################################################
#Update attribute table data and no geometry data - Weirs
##########################################################################################################################
    try:

        #Output
        outfc = "ICPR_BREACH"

        #Input
        infc = infc1 + "\\" + Filestem + "_" + "Link_Breach.csv"


        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(outfc, "CLEAR_SELECTION")

        except:

            pass

        #Fields for update of existing elements/features
        fields = ['NAME',
                  'EQUATION_DESC',
                  'BOTTOMWIDTH_MS',
                  'LEFTSIDESLOPE_MS',
                  'RIGHTSIDESLOPE_MS',
                  'BOTTOMELEV_MS',
                  'TOPELEV_MS',
                  'WSURFELEV_MS',
                  'DURATION_VAL',
                  'POWERCOEF_VAL',
                  'WEIRCOEF_VAL',
                  'DAMPENING_THRESHOLD',
                  'ICPR_GUID']

        #List index
        GDB_NAME = fields.index('NAME')
        GDB_EQUATION_DESC = fields.index('EQUATION_DESC')
        GDB_BOTTOMWIDTH_MS = fields.index('BOTTOMWIDTH_MS')
        GDB_LEFTSIDESLOPE_MS = fields.index('LEFTSIDESLOPE_MS')
        GDB_RIGHTSIDESLOPE_MS = fields.index('RIGHTSIDESLOPE_MS')
        GDB_BOTTOMELEV_MS = fields.index('BOTTOMELEV_MS')
        GDB_TOPELEV_MS = fields.index('TOPELEV_MS')
        GDB_WSURFELEV_MS = fields.index('WSURFELEV_MS')
        GDB_DURATION_VAL = fields.index('DURATION_VAL')
        GDB_POWERCOEF_VAL = fields.index('POWERCOEF_VAL')
        GDB_WEIRCOEF_VAL = fields.index('WEIRCOEF_VAL')
        GDB_DAMPENING_THRESHOLD = fields.index('DAMPENING_THRESHOLD')
        GDB_ICPR_GUID = fields.index('ICPR_GUID')

        #Create data dictionaries
        UpDict = {}
        AddDict = {}

        #Get path to implement edit session
        ###MUST BE IN EDIT SESSION TO USE MULTIPLE CURSORS
        desc = arcpy.Describe(outfc)
        path = desc.path
        del desc
        
        with arcpy.da.Editor(path)as edit:

            #Read CSV Data
            with open(infc,'r') as csv_file:
                first = True
                cursorInsert = arcpy.da.InsertCursor(outfc, fields)
                for line in csv_file:
                    if first== True:
                        first = False
                        header_row = iccsv.csv_parseline(line)

                        CSV_ID = header_row.index("ID")
                        CSV_ParentID = header_row.index("ParentID")
                        CSV_DampeningThreshold = header_row.index("DampeningThreshold")
                        CSV_TriggerElevation = header_row.index("TriggerElevation")
                        CSV_BreachDuration = header_row.index("BreachDuration")
                        CSV_TopElevation = header_row.index("TopElevation")
                        CSV_BottomElevation = header_row.index("BottomElevation")
                        CSV_FinalBottomWidth = header_row.index("FinalBottomWidth")
                        CSV_LeftSideSlope = header_row.index("LeftSideSlope")
                        CSV_RightSideSlope = header_row.index("RightSideSlope")
                        CSV_WeirType = header_row.index("WeirType")
                        CSV_WeirDischargeCoef = header_row.index("WeirDischargeCoef")
                        CSV_PowerCoef = header_row.index("PowerCoef")

                    else:

                        data = iccsv.csv_parseline(line)

                        #Set data formats for non-text used fields
                        data[CSV_DampeningThreshold] = float(data[CSV_DampeningThreshold])
                        data[CSV_TriggerElevation] = float(data[CSV_TriggerElevation])
                        data[CSV_BreachDuration] = float(data[CSV_BreachDuration])
                        data[CSV_TopElevation] = float(data[CSV_TopElevation])
                        data[CSV_BottomElevation] = float(data[CSV_BottomElevation])
                        data[CSV_FinalBottomWidth] = float(data[CSV_FinalBottomWidth])
                        data[CSV_LeftSideSlope] = float(data[CSV_LeftSideSlope])
                        data[CSV_RightSideSlope] = float(data[CSV_RightSideSlope])
                        data[CSV_WeirType] = int(data[CSV_WeirType])
                        data[CSV_WeirDischargeCoef] = float(data[CSV_WeirDischargeCoef])
                        data[CSV_PowerCoef] = float(data[CSV_PowerCoef])


                        #Create where clause
                        expression = "ICPR_GUID" + " = " + "'" + data[CSV_ID] + "'"
                        cursorUpdate = arcpy.da.UpdateCursor(outfc, fields,where_clause = expression)

                        #Determine is cursor is empty
                        i = 0
                        for row in cursorUpdate:

                            i = i + 1
                            if i >=1:
                                break

                        #Reset cursor
                        cursorUpdate.reset()

                        #If cursor has data update data
                        if i!=0:

                            for row in cursorUpdate:

                                ##################################
                                #Process data for direct transfer
                                ##################################

                                row[GDB_EQUATION_DESC] = data[CSV_WeirType]
                                row[GDB_BOTTOMWIDTH_MS] = data[CSV_FinalBottomWidth]
                                row[GDB_LEFTSIDESLOPE_MS] = data[CSV_LeftSideSlope]
                                row[GDB_RIGHTSIDESLOPE_MS] = data[CSV_RightSideSlope]
                                row[GDB_BOTTOMELEV_MS] = data[CSV_BottomElevation]
                                row[GDB_TOPELEV_MS] = data[CSV_TopElevation]
                                row[GDB_WSURFELEV_MS] = data[CSV_TriggerElevation]
                                row[GDB_DURATION_VAL] = data[CSV_BreachDuration]
                                row[GDB_POWERCOEF_VAL] = data[CSV_PowerCoef]
                                row[GDB_WEIRCOEF_VAL] = data[CSV_WeirDischargeCoef]
                                row[GDB_DAMPENING_THRESHOLD] = data[CSV_DampeningThreshold]
                                row[GDB_ICPR_GUID] = data[CSV_ID]

                                #################################
                                #Assign Link name
                                #################################
                                try:
                                    row[GDB_NAME] = LUpDict[data[CSV_ParentID]][1]
                                except:
                                    row[GDB_NAME] = LAddDict[data[CSV_ParentID]][1]

                                ##################################
                                #Process data for direct transfer
                                ##################################
                                #update row
                                cursorUpdate.updateRow(row)

                                #Updated Features / No geometry data
                                UpDict[data[CSV_ID]]=[data[CSV_ID]]

                            del cursorUpdate

                        ###############
                        #Add new data
                        ###############
                        else:

                            ##################################
                            #Process data for direct transfer
                            ##################################

                            EQUATION_DESC = data[CSV_WeirType]
                            BOTTOMWIDTH_MS = data[CSV_FinalBottomWidth]
                            LEFTSIDESLOPE_MS = data[CSV_LeftSideSlope]
                            RIGHTSIDESLOPE_MS = data[CSV_RightSideSlope]
                            BOTTOMELEV_MS = data[CSV_BottomElevation]
                            TOPELEV_MS = data[CSV_TopElevation]
                            WSURFELEV_MS = data[CSV_TriggerElevation]
                            DURATION_VAL = data[CSV_BreachDuration]
                            POWERCOEF_VAL = data[CSV_PowerCoef]
                            WEIRCOEF_VAL = data[CSV_WeirDischargeCoef]
                            DAMPENING_THRESHOLD = data[CSV_DampeningThreshold]
                            ICPR_GUID = data[CSV_ID]

                            #################################
                            #Assign Link name
                            #################################
                            try:
                                NAME = LUpDict[data[CSV_ParentID]][1]
                            except:
                                NAME = LAddDict[data[CSV_ParentID]][1]

                            ##################################
                            #Process data for direct transfer
                            ##################################

                            #New Record Data
                            In_Data = [NAME,
                                       EQUATION_DESC,
                                       BOTTOMWIDTH_MS,
                                       LEFTSIDESLOPE_MS,
                                       RIGHTSIDESLOPE_MS,
                                       BOTTOMELEV_MS,
                                       TOPELEV_MS,
                                       WSURFELEV_MS,
                                       DURATION_VAL,
                                       POWERCOEF_VAL,
                                       WEIRCOEF_VAL,
                                       DAMPENING_THRESHOLD,
                                       ICPR_GUID]

                            #Insert new record
                            cursorInsert.insertRow(In_Data)
                            #Added features/data
                            AddDict[data[CSV_ID]]=[data[CSV_ID]]
                            
                del cursorInsert

    except:
        arcpy.GetMessages()

    #Cycle through all data to delete values if required
    try:
        if Merge == False:

            cursorUpdate = arcpy.da.UpdateCursor(outfc, fields)

            for row in cursorUpdate:

                if row[GDB_ICPR_GUID] not in AddDict and row[GDB_ICPR_GUID] not in UpDict and len(row[GDB_NAME])>0:

                    cursorUpdate.deleteRow()

            del cursorUpdate
    except:
        arcpy.GetMessages()
