#Copyright 2020 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def EMCSet_write_file(outpath, stem):
    #Add forward slash for file path

    slash = "\\"
    import arcpy
    from iccsv import csv_writerow

    ####################################################################
    #Write table data to CSV
    ####################################################################


    try:
        infc = "ICPR4_EMC_Constituent_Set"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:
            pass

        #Define output location
        outfc = outpath + slash + stem + "_EMCConstituentSet.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ID",
             "Name",
             "Comment"]


        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Table info tuple
            SetDict = {}

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Define Comment
                    Comment = row.COMMENT

                    a = [row.ICPR_GUID,
                         row.NAME,
                         Comment]

                    Set_Data = (row.ICPR_GUID, row.NAME)
                    SetDict[row.NAME]=Set_Data

                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()
    ####################################################################
    #Write table data to CSV
    ####################################################################

    try:
        infc = "ICPR4_EMC_Constituent"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:
            pass

        #Define output location
        outfc = outpath + slash + stem + "_EMCConstituentSet_Constituent.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'Constituent',
             'DefCon_LandCoverZones',
             'DefCon_TimeStageNodes',
             'DefCon_InitialNodeVolume',
             'DefCon_ExternalHydrographs',
             'DefCon_BaseFlow',
             'DefCon_GroundwaterInflow',
             'IrreducibleConcentration']


        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Initial tuple
            EMC_TableDict = {}

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = SetDict[row.SET_NAME][0]

                    a = [GUID,
                         row.ICPR_GUID,
                         row.Constituent,
                         row.DefCon_LandCoverZones,
                         row.DefCon_TimeStageNodes,
                         row.DefCon_InitialNodeVolume,
                         row.DefCon_ExternalHydrographs,
                         row.DefCon_BaseFlow,
                         row.DefCon_GroundwaterInflow,
                         row.IrreducibleConcentration]

                    #Create Tuple
                    EMC_Data = (row.ICPR_GUID, row.Constituent, row.SET_NAME)
                    EMC_TableDict[row.SET_NAME + '~~~~~' + row.Constituent]=EMC_Data

                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()
    ####################################################################
    #Write table point data to CSV
    ####################################################################

    try:
        infc = "ICPR4_EMC_Constituent_Pnts"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:
            pass

        #Define output location
        outfc = outpath + slash + stem + "_EMCConstituentSet_Constituent_EMC.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'LandCoverZone',
             'EMC']

        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Assign GUID
                    nm = row.SET_NAME + '~~~~~' + row.Constituent
                    if nm in EMC_TableDict:
                        GUID=EMC_TableDict[nm][0]

                        a = [GUID,
                             row.ICPR_GUID,
                             row.LandCoverZone,
                             row.EMC]

                        csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
