#Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def CurveNumber_write_file(outpath, stem):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################


    try:
        infc = "ICPR4_CURVE_NUMBER_SET"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_CurveNumberSet.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ID",
             'Name',
             'Comment']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Table info tuple
            SetDict = {}
            
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Define Comment
                    Comment = row.Comment
                        
                    a = [row.ICPR_GUID,
                         row.Name,
                         Comment]

                    Set_Data = (row.ICPR_GUID, row.Name)
                    SetDict[row.Name]=Set_Data
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)


        del rows
        
    except:
        arcpy.GetMessages()

    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_CURVE_NUMBER_ZONES"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_CurveNumberSet_CurveNumber.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID",'LandCoverZone', 'SoilZone', 'CurveNumber']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
        
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = SetDict[row.SET_NAME][0]

                    a = [GUID, row.ICPR_GUID, row.LandCoverZone, row.SoilZone, row.CurveNumber]
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows
        
    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################
