##Copyright 2018 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def CrossSection_write_file(outpath, stem, ScDict, Xsec_Type_Flag):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow

    ####################################################################
    #Write table data to CSV          
    ####################################################################
    
    try:
                
        infc = "ICPR_XSECT"
        
        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
        
        outfc = outpath + slash + stem+ "_CrossSection.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        #Empty Xsec_Info tuple
        XsecDict = {}
       
        # Write headers to CSV
        a = ["ParentID","ID", "Name", "Type",
             "Lid", "Comment", "TextX", "TextY",
             "TextZ", "TextAngle", "IsPlaced",
             "ShapeIsClosed"]
        
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   
                
            # Enter for loop for each feature/row
            for row in rows:

                #Assign ID and ParentID
                GUID = ScDict[row.SCENARIO][0]

                #Include Cross Section Flags
                Xsec_Index = [x[1] for x in Xsec_Type_Flag].index(row.XSECT_TYPE)
                Xsec_Include = Xsec_Type_Flag[Xsec_Index][2]
                

                #Store cross section data in tuple
                Xsec_Data = (GUID, row.ICPR_GUID, Xsec_Include, row.NAME, row.XSECT_TYPE, row.LID)
                XsecDict[row.NAME]=Xsec_Data

                if Xsec_Include == "true":

                    try:
                        
                        #Check if geometry data exists
                        IsPlaced = row.ISPLACED

                        #Calculate text location at midpoint of link
                        midpoint = row.shape.positionAlongLine(0.50,True).firstPoint
                        TextX = midpoint.X
                        TextY = midpoint.Y                            

                    except:
                        
                        #If geometry data does not exist do this
                        IsPlaced = 0
                        TextX = 0
                        TextY = 0

                    #Define Comment
                    Comment = row.Comment                

                    #Write results to file
                    a = [GUID,row.ICPR_GUID, row.Name, row.XSECT_TYPE,
                        row.LID, Comment, TextX, TextY,
                        0, 0, IsPlaced,
                        row.SHAPE_ISCLOSED]

                    csv_writerow(f,a)

        del rows
                    
    except:

        arcpy.GetMessages()

    ####################################################################
    #Create coordinates
    ####################################################################

    try:
        
        infc = "ICPR_XSECT"
        outfc = outpath + slash + stem + "_CrossSection_Shape_Point.csv"        

        # Identify the input feature class to describe
        #
        desc = arcpy.Describe(infc)
        
        shapefieldname = desc.ShapeFieldName

        # Create search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID", "Vertex", "X", "Y", "Z"]
        with open(outfc,'wb') as f:
            csv_writerow(f,a)   

            # Enter for loop for each feature/row
            for row in rows:
                # Create the geometry object
                #
                feat = row.getValue(shapefieldname)
                partnum = 0

                #Flag to include or not to include
                Xsec_Include = XsecDict[row.NAME][2]
                

                if Xsec_Include == "true":

                    #Assign Parent GUID
                    GUID = XsecDict[row.NAME][1]            

                    # Count the number of points in the current multipart feature
                    #
                    partcount = feat.partCount                    

                    # Enter while loop for each part in the feature (if a singlepart feature
                    # this will occur only once)
                    #
                    while partnum < partcount:
                        # Print the part number
                        #
                        part = feat.getPart(partnum)
                        pnt = part.next()
                        pntcount = 0
                
                        # Enter while loop for each vertex
                        #
                        while pnt:
                            #Write x, y coordinates of current point to CSV
                            a = [GUID, "{"+str(uuid.uuid4())+"}", pntcount,  pnt.X, pnt.Y, 0]

                            csv_writerow(f,a)
                                        
                            pnt = part.next()
                            pntcount = pntcount + 1
                
                            # If pnt is null, either the part is finished or there is an 
                            #   interior ring
                            #
                            if not pnt: 
                                pnt = part.next()
                                if pnt:
                                    print("Interior Ring:")
                        partnum = partnum + 1

        del rows
                    
    except:
        arcpy.GetMessages()


    ####################################################################################################
    #Write out returned values (GUID, row.ICPR_GUID, Xsec_Include, row.NAME, row.XSECT_TYPE, row.row.LID)         
    ####################################################################################################
    try:

        return XsecDict

    except:
        arcpy.GetMessages()
######################################################################################################
######################################################################################################

#           Channel Cross-Sections
######################################################################################################
######################################################################################################

def CrossSection_Channel_write_file(outpath, stem, XsecDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR_XSECT"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_CrossSection_Channel.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID", "ConveyanceMethod",
             "LeftOverbankStation", "RightOverbankStation"]
             
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)


            #Channel Xsec Info tuple
            ChanXsecDict = {}
            
            # Enter for loop for each feature/row
            for row in rows:
                
                #Only write out data with ICPR name specified
                if row.NAME is not None:
                    
                    if row.XSECT_TYPE == 71:

                        #Determine Parent GUID
                        GUID = XsecDict[row.NAME][1]

                        GUID2 = "{"+str(uuid.uuid4())+"}"

                        a = [GUID, GUID2,row.CONVEYANCE_METHOD,
                            row.LSTATION_OVERBANK, row.RSTATION_OVERBANK]                    
                        
                        csv_writerow(f,a)

                        #Add data to tuple
                        Xsec_Data = (GUID2, row.NAME)
                        
                        ChanXsecDict[row.NAME]=Xsec_Data
        del rows

    except:
        arcpy.GetMessages()
        

    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR_XSECT_STATIONS"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_CrossSection_Channel_Bottom_Point.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc,sort_fields="NAME; PT_ORDER")

        # Write headers to CSV
        a = ["ParentID","ID", "Order",
             "Station", "Elevation",
             "ManningsN"]             
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
            
            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR name specified
                if row.NAME is not None:

                    try:

                        #Check type
                        X_Type = XsecDict[row.NAME][4]

                        #Only write out points for channel cross-sections
                        if X_Type == 71:

                            if row.ISSTATION == 1:

                                #Determine Parent GUID                          
                                GUID = ChanXsecDict[row.NAME][0]

                                a = [GUID, row.ICPR_GUID,row.PT_ORDER,
                                    row.STATION, row.ELEV, row.MANNINGS_N]
                                
                                csv_writerow(f,a)

                    except:
                        arcpy.GetMessages()

        del rows


    except:
        arcpy.GetMessages()

    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_XSECT_CHANNEL_LID_POINTS"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_CrossSection_Channel_Lid_Point.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc,sort_fields="NAME; PT_ORDER")

        # Write headers to CSV
        a = ["ParentID","ID", "Order",
             "Station", "Elevation",
             "ManningsN"]             
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
            
            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR name specified
                if row.NAME is not None:

                    try:

                        #Check type
                        X_Lid = XsecDict[row.NAME][5]
                        X_Type = XsecDict[row.NAME][4]

                        #Only write out points for channel cross-sections
                        if X_Type == 71:

                            #Only write out points for channel with lids specified as "Yes"                    
                            if X_Lid == 1:            

                                #Determine Parent GUID                         
                                GUID = ChanXsecDict[row.NAME][0]

                                a = [GUID, row.ICPR_GUID,row.PT_ORDER,
                                    row.STATION, row.ELEV, row.MANNINGS_N]
                                
                                csv_writerow(f,a)

                    except:
                        arcpy.GetMessages()
        del rows

    except:
        arcpy.GetMessages()


######################################################################################################
######################################################################################################

#Weir Cross-Sections module
######################################################################################################
######################################################################################################

def CrossSection_Weir_write_file(outpath, stem, XsecDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy, uuid
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR_XSECT"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_CrossSection_Weir.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID","ID"]
             
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)


            #Weir Xsec Info tuple
            WeirXsecDict = {}
            
            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR name specified
                if row.NAME is not None:

                    if row.XSECT_TYPE == 72:

                        #Determine Parent GUID
                        GUID = XsecDict[row.NAME][1]

                        GUID2 = "{"+str(uuid.uuid4())+"}"

                        a = [GUID, GUID2]                    
                        
                        csv_writerow(f,a)

                        #Add data to tuple
                        Xsec_Data = (GUID2, row.NAME)
                        
                        WeirXsecDict[row.NAME]=Xsec_Data

        del rows

    except:
        arcpy.GetMessages()
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR_XSECT_STATIONS"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_CrossSection_Weir_Bottom_Point.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc,sort_fields="NAME; PT_ORDER")

        # Write headers to CSV
        a = ["ParentID","ID", "Order",
             "Station", "Elevation"]  
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
            
            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR name specified
                if row.NAME is not None:

                    try:

                        #Check type
                        X_Type = XsecDict[row.NAME][4]

                        #Only write out points for weir cross-sections
                        if X_Type == 72:

                            if row.ISSTATION == 1:

                                #Determine Parent GUID                          
                                GUID = WeirXsecDict[row.NAME][0]

                                a = [GUID, row.ICPR_GUID,row.PT_ORDER,
                                    row.STATION, row.ELEV]
                                
                                csv_writerow(f,a)

                    except:
                        pass 

        del rows
        
    except:
        arcpy.GetMessages()
        
 

    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_XSECT_WEIR_LID_POINTS"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_CrossSection_Weir_Lid_Point.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc,sort_fields="NAME; PT_ORDER")

        # Write headers to CSV
        a = ["ParentID","ID", "Order",
             "Station", "Elevation"]             
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
            
            # Enter for loop for each feature/row
            for row in rows:

                #Only write out data with ICPR name specified
                if row.NAME is not None:

                    try:

                        #Check type
                        X_Lid = XsecDict[row.NAME][5]
                        X_Type = XsecDict[row.NAME][4]

                        #Only write out points for weir cross-sections
                        if X_Type == 72:

                            #Only write out points for weir with lids specified as "Yes"                    
                            if X_Lid == 1:            

                                #Determine Parent GUID
                                GUID = WeirXsecDict[row.NAME][0]

                                a = [GUID, row.ICPR_GUID,row.PT_ORDER,
                                    row.STATION, row.ELEV]
                                
                                csv_writerow(f,a)

                    except:
                        pass
        
        del rows
        
    except:
        arcpy.GetMessages()

 
######################################################################################################
######################################################################################################
