#Copyright 2022 Streamline Technologies, Inc.
#All Rights Reserved
#Name:  Frank W. McKinnie, PE, CFM
#Company: Streamline Technologies, Inc.
#Purpose:  Writes CSV for import into ICPR4 from GWIS version 2.1 GDB

def BottomClipTable_write_file(outpath, stem, ScDict):    
    #Add forward slash for file path
    
    slash = "\\"
    import arcpy
    from iccsv import csv_writerow
    
    ####################################################################
    #Write table data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_BottomClip_Table"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_BottomClipTable.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'Name',
             'Type',
             'Comment']
             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)

            #Table info tuple
            RatingCurveDict = {}
            
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = ScDict[row.SCENARIO][0]

                    #Define Comment
                    Comment = row.Comment
                        
                    a = [GUID,
                         row.ICPR_GUID,
                         row.NAME,
                         row.Type,
                         Comment]


                    Rating_Data = (row.ICPR_GUID, row.Name)
                    RatingCurveDict[row.Name]=Rating_Data
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()


    ####################################################################
    #Write table point data to CSV          
    ####################################################################

    try:
        infc = "ICPR4_BottomClip_PTS"

        #Clear current selection
        try:
            arcpy.SelectLayerByAttribute_management(infc, "CLEAR_SELECTION")
        except:            
            pass
                   
        #Define output location
        outfc = outpath + slash + stem + "_BottomClipTable_Point.csv"

        # Create new search cursor
        #
        rows = arcpy.SearchCursor(infc)

        # Write headers to CSV
        a = ["ParentID",
             "ID",
             'Year',
             'Month',
             'Day',
             'X',
             'Y']

             
        with open(outfc,'wb') as f:
            csv_writerow(f,a)
        
            # Enter for loop for each feature/row
            for row in rows:

                try:

                    #Check GUID
                    GUID = RatingCurveDict[row.NAME][0]

                    
                    #Convert "Y" to feet
                    try:
                        
                        Y = round(row.Y,4)
                        
                    except:
                        
                        Y =0                  

                    a = [GUID,
                         row.ICPR_GUID,
                         row.YEAR,
                         row.MONTH,
                         row.DAY,
                         row.X,
                         Y]
                    
                    csv_writerow(f,a)

                except Exception as e:
                    arcpy.AddMessage(e)

        del rows

    except:
        arcpy.GetMessages()

######################################################################################################
######################################################################################################
